% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_summary.R
\name{drop_summary}
\alias{drop_summary}
\title{Summarize Missing Data Metrics for Each Column}
\usage{
drop_summary(data)
}
\arguments{
\item{data}{A dataframe for which to analyze missing data.}
}
\value{
A dataframe containing the following columns:
\itemize{
\item \strong{column}: The name of each column in the input dataframe.
\item \strong{drop}: The number of dropped rows (missing values) for that column.
\item \strong{sec_na}: The number of sections of consecutive NAs for that column.
\item \strong{sec_length}: The mode (most frequent length) of sections of consecutive NAs for that column.
\item \strong{single_na}: The number of single NA values (isolated missing values) for that column.
\item \strong{na}: The total number of missing (NA) values for that column.
\item \strong{complete}: The proportion of complete rows for that column, where a value of 1 means no missing data, and values closer to 0 mean more missing data.
}
}
\description{
The \code{drop_summary} function generates a summary of missing data (NA values) for each column in a dataframe.
It computes various metrics such as the number of dropout participants, section NAs, the mode length of those missing value sections for, and the proportion of complete cases for each column.
}
\details{
The function calls a C API to compute some metrics, which are then processed and returned as a summary dataframe.
}
\examples{
\dontrun{
# Example usage with the 'flying' dataframe
summary_result <- drop_summary(flying)
print(summary_result)
}

}
