% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dose_pp.R
\name{f_dose_pp}
\alias{f_dose_pp}
\title{Drug Demand Per Protocol}
\usage{
f_dose_pp(
  dosing_summary_t0,
  vf_ongoing,
  vf_new,
  dosing_schedule_df,
  t0,
  t,
  pilevel
)
}
\arguments{
\item{dosing_summary_t0}{A data frame for the cumulative doses
dispensed before the cutoff date. It contains the following
variables:
\code{kit}, \code{kit_name}, and \code{cum_dose_t0}.}

\item{vf_ongoing}{A data frame for the observed drug dispensing
data for ongoing patients with drug dispensing records.
It includes the following variables:
\code{draw}, \code{kit}, \code{kit_name}, \code{usubjid},
\code{day}, \code{dose}, \code{arrivalTime}, \code{treatment},
\code{treatment_description}, \code{time}, and \code{totalTime}.}

\item{vf_new}{A data frame for the randomization date for new
patients and ongoing patients with no drug dispensing records.
It includes the following variables:
\code{draw}, \code{kit}, \code{kit_name}, \code{usubjid},
\code{arrivalTime}, \code{treatment}, \code{treatment_description},
\code{time}, and \code{totalTime}.}

\item{dosing_schedule_df}{A data frame providing dosing schedule
information. It contains the following variables:
\code{kit}, \code{target_days}, \code{target_dose}, and
\code{max_cycles}.}

\item{t0}{The cutoff date relative to the trial start date.}

\item{t}{A vector of new time points for drug dispensing prediction.}

\item{pilevel}{The prediction interval level.}
}
\value{
A data frame for dosing summary by drug and time point per
protocol. It contains the following variables:
\code{kit}, \code{kit_name}, \code{t}, \code{n}, \code{pilevel},
\code{lower}, \code{upper}, \code{mean}, and \code{var}.
}
\description{
Obtains drug demand prediction based on protocol-assumed
visit and dosing schedules.
}
\examples{

\donttest{
# Design stage drug demand forecasting per protocol.

set.seed(312)
library(dplyr)

pred <- eventPred::getPrediction(
  df = NULL,
  to_predict = "enrollment and event",
  target_n = 250,
  target_d = 250,
  enroll_prior = list(
    model = "piecewise poisson",
    theta = c(-0.74, -1.18),
    vtheta = matrix(c(0.0087, 0, 0, 0.0082), 2, 2),
    accrualTime = c(0, 240)),
  event_prior = list(
    list(model = "log-logistic",
         theta = c(5.9, -0.2),
         vtheta = matrix(c(0.022, 0.004, 0.004, 0.012), 2, 2)),
    list(model = "log-logistic",
         theta = c(5.6, 0.02),
         vtheta = matrix(c(0.032, 0.003, 0.003, 0.012), 2, 2)),
    list(model = "log-logistic",
         theta = c(5.7, -0.3),
         vtheta = matrix(c(0.071, 0.013, 0.013, 0.054), 2, 2))),
  dropout_prior = NULL,
  pilevel = 0.95,
  nyears = 3,
  nreps = 200,
  showsummary = FALSE,
  showplot = FALSE,
  by_treatment = TRUE,
  ngroups = 3,
  alloc = c(2, 2, 1),
  treatment_label = c("Drug A + Drug B",
                      "Drug C + Placebo",
                      "Drug A + Placebo"))

dosing_summary_t0 = kit_description_df \%>\%
  mutate(cum_dose_t0 = 0) \%>\%
  select(-c("drug", "drug_name"))

vf_ongoing_new <- f_ongoing_new(
  pred$event_pred$newEvents, kit_description_df,
  treatment_by_drug_df, NULL)

t0 = 1
nyears = 3
t1 = t0 + nyears*365
t = c(seq(t0, t1, 30), t1)
pilevel = 0.95

dosing_pred_pp <- f_dose_pp(
  dosing_summary_t0, vf_ongoing_new$vf_ongoing,
  vf_ongoing_new$vf_new, dosing_schedule_df, t0, t, pilevel)

head(dosing_pred_pp)
}

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
