% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_fun.R
\name{pal_n_sq}
\alias{pal_n_sq}
\title{Get n-by-n dedicated colors of a color palette}
\usage{
pal_n_sq(n = "all", pal = pal_ds4psy)
}
\arguments{
\item{n}{The desired number colors of pal (as a number) 
or the character string \code{"all"} (to get all colors of \code{pal}). 
Default: \code{n = "all"}.}

\item{pal}{A color palette (as a data frame). 
Default: \code{pal = \link{pal_ds4psy}}.}
}
\description{
\code{pal_n_sq} returns \code{n^2} dedicated colors of a color palette \code{pal} 
(up to a maximum of \code{n = "all"} colors).
}
\details{
Use the more specialized function \code{unikn::usecol} for choosing 
\code{n} dedicated colors of a known color palette.
}
\examples{
pal_n_sq(1)  #  1 color: seeblau3
pal_n_sq(2)  #  4 colors
pal_n_sq(3)  #  9 colors (5: white)
pal_n_sq(4)  # 11 colors (6: white)

}
\seealso{
\code{\link{plot_tiles}} to plot tile plots.

Other color objects and functions: 
\code{\link{pal_ds4psy}}
}
\concept{color objects and functions}
