% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dead_functions.R
\name{dsm.var.movblk}
\alias{dsm.var.movblk}
\title{Variance estimation via parametric moving block bootstrap}
\usage{
dsm.var.movblk(
  dsm.object,
  pred.data,
  n.boot,
  block.size,
  off.set,
  ds.uncertainty = FALSE,
  samp.unit.name = "Transect.Label",
  progress.file = NULL,
  bs.file = NULL,
  bar = TRUE
)
}
\arguments{
\item{dsm.object}{object returned from \code{\link{dsm}}.}

\item{pred.data}{either: a single prediction grid or list of prediction
grids. Each grid should be a \code{data.frame} with the same columns as the
original data.}

\item{n.boot}{number of bootstrap resamples.}

\item{block.size}{number of segments in each block.}

\item{off.set}{a a vector or list of vectors with as many elements as there
are in \code{pred.data}. Each vector is as long as the number of rows in the
corresponding element of \code{pred.data}. These give the area associated with
each prediction cell. If a single number is supplied it will be replicated
for the length of \code{pred.data}.}

\item{ds.uncertainty}{incorporate uncertainty in the detection function? See
Details, below. Note that this feature is EXPERIMENTAL at the moment.}

\item{samp.unit.name}{name sampling unit to resample (default
'Transect.Label').}

\item{progress.file}{path to a file to be used (usually by Distance) to
generate a progress bar (default \code{NULL} -- no file written).}

\item{bs.file}{path to a file to store each bootstrap round. This stores all
of the bootstrap results rather than just the summaries, enabling
outliers to be detected and removed. (Default \code{NULL}).}

\item{bar}{should a progress bar be printed to screen? (Default \code{TRUE}).}
}
\description{
This function is deprecated, use \link{dsm_var_movblk}.
}
