% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wauc-statistic.R
\name{wauc_from_os}
\alias{wauc_from_os}
\title{Weighted AUC from Outlier Scores}
\usage{
wauc_from_os(os_train, os_test, weight = NULL)
}
\arguments{
\item{os_train}{Outlier scores in training (reference) set.}

\item{os_test}{Outlier scores in test set.}

\item{weight}{Numeric vector of weights of length
\code{length(os_train) + length(os_test)}. The first \code{length(os_train)}
weights belongs to the training set, the rest is for the test set. If
\code{NULL}, the default, all weights are set to 1.}
}
\value{
The weighted AUC (scalar value) given the weighting scheme.
}
\description{
Computes the weighted AUC with the weighting scheme described in
Kamulete, V. M. (2021). This assumes that the training set is the reference
distribution and specifies a particular functional form to derive weights
from threshold scores.
}
\examples{
\donttest{
library(dsos)
set.seed(12345)
os_train <- rnorm(n = 100)
os_test <- rnorm(n = 100)
test_stat <- wauc_from_os(os_train, os_test)
}

}
\references{
Kamulete, V. M. (2022).
\emph{Test for non-negligible adverse shifts}.
In The 38th Conference on Uncertainty in Artificial Intelligence. PMLR.
}
\concept{statistic}
