% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.dsp}
\alias{summary.dsp}
\title{Summarize DSP MCMC chains}
\usage{
\method{summary}{dsp}(object, pars, probs = c(0.025, 0.25, 0.5, 0.75, 0.975), ...)
}
\arguments{
\item{object}{object of class dsp from \code{\link[=dsp_fit]{dsp_fit()}}}

\item{pars}{parameter names specified for summaries; currently defaults to all parameters named in object$mcmc_output}

\item{probs}{numeric vector of \code{\link[=quantile]{quantile()}}s requested for posterior summary of pars. Defaults to c(0.025, 0.25, 0.50, 0.75, 0.975)}

\item{...}{currently not being used}
}
\value{
Returns a named list of the same length as pars where within each element of the list
is a numeric matrix (vector parameters) or vector (scalar parameters). For matrices, each row is a time point (or dimension) of the parameter and each column
is a named summary. The names are accessible with \code{colnames}. For vectors (scalar parameters), each element is a named summary.
}
\description{
Summarize DSP MCMC chains
}
\examples{
set.seed(200)
signal = c(rep(0, 50), rep(10, 50))
noise = rep(1, 100)
noise_var = rep(1, 100)
for (k in 2:100){
  noise_var[k] = exp(0.9*log(noise_var[k-1]) + rnorm(1, 0, 0.5))
  noise[k] = rnorm(1, 0, sqrt(noise_var[k])) }

y = signal + noise
model_spec = dsp_spec(family = "gaussian", model = "changepoint",
                      D = 1, useAnom = TRUE, obsSV = "SV")
mcmc_output = dsp_fit(y, model_spec = model_spec, nsave = 500, nburn = 500)

summary_fit <- summary(mcmc_output)
summary_fit$mu[,"mean"]
summary_fit$evol_sigma_t2[,"mean"]

}
