% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_plot_quality.R
\name{op_plot_quality}
\alias{op_plot_quality}
\title{Plot Data Quality (Confidence Ratings or Completeness)}
\usage{
op_plot_quality(df, plot_type = "confidence", threshold_line = 50)
}
\arguments{
\item{df}{A dataframe containing the confidence data, with columns for base_filename, region, person, and confidence values.}

\item{plot_type}{Character. Either "confidence" to plot the mean confidence rating, "completeness" to plot the percentage of completeness, or "both" to plot both.
Default is "confidence".}

\item{threshold_line}{Numeric. The value at which to draw a dashed horizontal line. Default is 50.}
}
\value{
A ggplot object or a combined plot if "both" is selected.
}
\description{
This function plots either the mean confidence ratings, the percentage of completeness (i.e., data present),
or both for the given dataframe. It can handle data for one or multiple persons and regions, creating separate panels for each.
}
\examples{
# Example usage:
# Path to example CSV file included with the package
file_path <- system.file("extdata/csv_data/A-B_body_dyad.csv", package = "duet")

# Load the data
data <- read.csv(file_path)

# plot <- op_plot_data_quality(df, plot_type = "both", threshold_line = 75)
# print(plot)
}
