% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amDrivenDVI.R
\name{amDrivenDVI}
\alias{amDrivenDVI}
\title{AM driven DVI}
\usage{
amDrivenDVI(
  dvi,
  fams = NULL,
  threshold = 10000,
  threshold2 = max(1, threshold/10),
  verbose = TRUE
)
}
\arguments{
\item{dvi}{A \code{dviData} object.}

\item{fams}{A character; the names of families to consider. By default, all
families. Special keywords: "simple" (all families with exactly 1 missing)
and "nonsimple" (all families with > 1 missing).}

\item{threshold}{LR threshold for 'certain' match.}

\item{threshold2}{LR threshold for 'probable' match (in \emph{simple} families).}

\item{verbose}{A logical.}
}
\value{
A list of \code{dviReduced} and \code{summary}.
}
\description{
AM-driven identification, i.e., considering one AM family at a time. Simple
families (exactly 1 missing) are handled directly from the LR matrix, while
nonsimple families are analysed with \code{\link[=dviJoint]{dviJoint()}}.
}
\details{
Note: This function assumes that undisputed identifications have been
removed. Strange outputs may occur otherwise.
}
\examples{
w = amDrivenDVI(example2)
w$summary
w$dviReduced

# Bigger example: Undisputed first
u = findUndisputed(planecrash)
u$summary

# AM-driven analysis of the remaining
amDrivenDVI(u$dviReduced, threshold2 = 500)

}
