% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseLR.R
\name{pairwiseLR}
\alias{pairwiseLR}
\title{Pairwise LR matrix}
\usage{
pairwiseLR(
  dvi,
  pairings = NULL,
  ignoreSex = FALSE,
  limit = 0,
  nkeep = NULL,
  check = TRUE,
  numCores = 1,
  verbose = FALSE
)
}
\arguments{
\item{dvi}{A \code{dviData} object, typically created with \code{\link[=dviData]{dviData()}}.}

\item{pairings}{A list of possible pairings for each victim. If NULL, all
sex-consistent pairings are used.}

\item{ignoreSex}{A logical.}

\item{limit}{A nonnegative number controlling the \code{pairings} slot of the
output: Only pairings with LR greater or equal to \code{limit} are kept. If zero
(default), pairings with LR > 0 are kept.}

\item{nkeep}{An integer, or NULL. If given, only the \code{nkeep} most likely
pairings are kept for each victim.}

\item{check}{A logical, indicating if the input data should be checked for
consistency.}

\item{numCores}{An integer; the number of cores used in parallelisation.
Default: 1.}

\item{verbose}{A logical.}
}
\value{
A list with 3 elements:
\itemize{
\item \code{LRmatrix}: A matrix containing the pairwise LR values.
\item \code{LRlist}: A list of numerical vectors, containing the pairwise LRs in
list format.
\item \code{pairings}: A reduced version of the input \code{pairings}, keeping only
entries with corresponding LR >= \code{limit}. For the default case \code{limit = 0}
a strict inequality is used, i.e., LR > 0.
}
}
\description{
For a given DVI problem, compute the matrix consisting of pairwise likelihood
ratios \eqn{LR_{i,j}} comparing \eqn{V_i = M_j} to the null. The output may
be reduced by specifying arguments \code{limit} or \code{nkeep}.
}
\examples{
pairwiseLR(example1, verbose = TRUE)

}
