% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_check_taxon_id.R
\name{dct_check_taxon_id}
\alias{dct_check_taxon_id}
\title{Check taxonID}
\usage{
dct_check_taxon_id(
  tax_dat,
  on_fail = dct_options()$on_fail,
  on_success = dct_options()$on_success,
  quiet = dct_options()$quiet
)
}
\arguments{
\item{tax_dat}{Dataframe; taxonomic database in DwC format.}

\item{on_fail}{Character vector of length 1, either "error" or "summary". Describes what to do if the check fails. Default \code{"error"}.}

\item{on_success}{Character vector of length 1, either "logical" or "data". Describes what to do if the check passes. Default \code{"data"}.}

\item{quiet}{Logical vector of length 1; should warnings be silenced? Default \code{FALSE}.}
}
\value{
Depends on the result of the check and on values of \code{on_fail} and
\code{on_success}:
\itemize{
\item If the check passes and \code{on_success} is "logical", return \code{TRUE}
\item If the check passes and \code{on_success} is "data", return the input dataframe
\item If the check fails and \code{on_fail} is "error", return an error
\item If the check fails and \code{on_fail} is "summary", issue a warning and
return a dataframe with a summary of the reasons for failure
}
}
\description{
Check for correctly formatted taxonID column in Darwin Core taxonomic data.
}
\details{
The following rules are enforced:
\itemize{
\item taxonID may not be missing (NA)
\item taxonID must be unique
}
}
\examples{
dct_check_taxon_id(
  data.frame(taxonID = NA_character_),
  on_fail = "summary", quiet = TRUE
)
dct_check_taxon_id(data.frame(taxonID = 1))
}
