% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateCA.R
\name{annotateCA}
\alias{annotateCA}
\title{Annotate Chronoamperogram}
\usage{
annotateCA(filename, time.delay, scale.factor = 1, main_title = NULL)
}
\arguments{
\item{filename}{Name of the file that contains the results of a simulated chronoamperometry experiment.}

\item{time.delay}{Time after the application of a pulse for which the current is reported.}

\item{scale.factor}{Setting to a value less than 1 adjusts the \emph{y}-axis limits so that the limits are not defined by the current spike.}

\item{main_title}{An optional main title.}
}
\value{
Returns a plot of the chronoamperogram with annotations.
}
\description{
Plots a chronoamperogam and annotates it with either the
current for a single pulse experiment, or, for a double pulse
experiment, with the currents after both the forward pulse and
the reverse pulse, and the current ratio. The currents are
displayed for a designated time after a pulse, which defaults
to the length of the pulse if a value is not provided.
}
\examples{

ex_ca = simulateCA(e.start = 0.25, e.pulse = -0.25, e.form = 0,
  pulses = "double", t.2 = 20, x.units = 100, t.units = 1000)
annotateCA(ex_ca, time.delay = 0.5)
}
