% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateLSV.R
\name{annotateLSV}
\alias{annotateLSV}
\title{Annotate Linear Sweep Voltammogram}
\usage{
annotateLSV(filename, potential.per = 5, main_title = NULL)
}
\arguments{
\item{filename}{Name of the file that contains the results of a simulated linear sweep voltammetry experiment.}

\item{potential.per}{The percentage of points from the beginning of the potential scan used to set the baseline for measuring the peak current.}

\item{main_title}{An optional main title.}
}
\value{
Returns a plot of the linear sweep voltammogram with annotations.
}
\description{
Plots a linear sweep voltammogram and annotates it with values
for either the cathodic peak potential (Epc) and cathodic peak
current (ip,c), or the anodic peak potential (Epa) and the
anodic peak current (ip,a). The baseline for determining the
peak currents is set using a defined percentage of points at
the beginning of potential scan.
}
\examples{
ex_lsv = simulateLSV(e.start = 0.25, e.end = -0.25, e.form = 0,
  stir.rate = "fast", x.units = 100, t.units = 1000)
annotateLSV(ex_lsv)
}
