% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_seq_len_hist.R
\name{plot_seq_len_hist}
\alias{plot_seq_len_hist}
\title{Plot sequence length distribution}
\usage{
plot_seq_len_hist(Hash_tibble, length_col, binwidth = 1, label_interval = 5)
}
\arguments{
\item{Hash_tibble}{A tibble containing a numeric column with sequence lengths.}

\item{length_col}{The column of `Hash_tibble` containing sequence lengths (unquoted).}

\item{binwidth}{Width of histogram bins. Default = 1.}

\item{label_interval}{Interval for x-axis labels. Default = 5.}
}
\value{
A ggplot object.
}
\description{
This function takes a tibble produced by `fasta_reader()` or `fastq_reader()`
and plots the distribution of sequence lengths.
}
\examples{
data("example_hashes")
plot_seq_len_hist(example_hashes, seq_len)
}
