% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_resample.R
\name{summarise_resample_medians}
\alias{summarise_resample_medians}
\title{Summarise resample medians}
\usage{
summarise_resample_medians(data, ..., ci_level = 0.95)
}
\arguments{
\item{data}{List of abc results from abc_resample}

\item{...}{Additional custom summary functions (named functions)}

\item{ci_level}{Confidence level for intervals (default 0.95)}
}
\value{
Data frame with summary statistics for each parameter
}
\description{
Calculate summary statistics for parameter medians across resample iterations.
Returns mean, median, and confidence intervals of the median distributions.
}
\examples{
# Load ABC input data from example simulation
abc_input <- readRDS(
  system.file("extdata", "rdm_minimal", "abc", "abc_input.rds", package = "eam")
)

# Perform ABC resampling
results <- abc_resample(
  target = abc_input$target,
  param = abc_input$param,
  sumstat = abc_input$sumstat,
  n_iterations = 100,
  n_samples = 100,
  tol = 0.5,
  method = "rejection"
)

# summarise the resample medians
summary_stats <- summarise_resample_medians(results, ci_level = 0.95)
print(summary_stats)
}
