% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_job_split}
\alias{EPM_job_split}
\title{Split A PubMed Retrieval Job into Manageable Batches.}
\usage{
EPM_job_split(
  query_string,
  api_key = NULL,
  max_records_per_batch = 9999,
  verbose = FALSE
)
}
\arguments{
\item{query_string}{String (character vector of length 1), 
corresponding to the query string.}

\item{api_key}{String (character vector of length 1), 
corresponding to the NCBI API key. Can be NULL.}

\item{max_records_per_batch}{Integer, maximum number of records that should
be expected be sub-query. This number should be in the range 1,000 
to 10,000 (typicall, max_records_per_batch=10,000).}

\item{verbose}{logical, shall progress information be printed to console.}
}
\value{
Character vector including the response from the server.
}
\description{
Assess the number of PubMed records expected from a user-provided query
and split the job in multiple sub-queries if the number is bigger than 
"max_records_per_batch" (typically, n=10,000). 
Sub-queries are split according to the "Create Date" of 
PubMed records. This does not support splitting jobs returning more than 
"max_records_per_batch" (typically, n=10,000) records that have 
the same "Create Date" (i.e., "[CRDT]").
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  qry <- 'Damiano Fantini[AU] AND "2018"[PDAT]'
  easyPubMed:::EPM_job_split(query_string = qry, verbose = TRUE)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)
                           



}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
