% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nem_plot.R
\name{nem_plot,ef2-method}
\alias{nem_plot,ef2-method}
\title{Visualizing the energy structure of nematode communities (two-factor)}
\usage{
\S4method{nem_plot}{ef2}(object)
}
\arguments{
\item{object}{A \code{\link{ef2-class}} object.}
}
\value{
An \code{gg} or \code{ggplot} object.
}
\description{
The \code{\link{nem_plot}} function is generalized to the \code{\link{ef2-class}}
and is used to visualize the energy structure of nematode communities. a five-node
food web was constructed with bacterivores, fungivores and herbivores receiving
energy from basal resources (R), omnivores-carnivores receiving energy from other
nodes. Numbers along the lines represented energy flux (ug C / 100 g dry soil / day).
The size of nodes corresponds to the fresh biomass (ug / 100 g dry soil).
Uniformity (U) of soil nematode energetic structure (unitless, mean ± standard error)
was calculated as the ratio of the mean of summed energy flux through each
energy channel to the standard deviation of these mean values.
}
\details{
To facilitate code interpretation, it is recommended to use the pipe symbol
\code{\link{|>}} to connect functions:

\if{html}{\out{<div class="sourceCode">}}\preformatted{nem_plot <- nem |> calc_nemindex() |> calc_ef2(con_crop, season) |> nem_plot()
}\if{html}{\out{</div>}}
}
\examples{
nem <- read_nem(tab = easynem_example("nemtab1.csv"),
                tax = easynem_example("nemtax1.csv"),
                meta = easynem_example("nemmeta1.csv"))
nem_plot <- nem |>
            calc_nemindex() |>
            calc_ef2(con_crop, season) |>
            nem_plot()
nem_plot
}
\references{
\itemize{
\item Wan, Bingbing, et al. "Organic amendments increase the flow uniformity of
energy across nematode food webs." Soil Biology and Biochemistry 170 (2022): 108695.
\item Ferris, H., 2010. Form and function: metabolic footprints of nematodes in the soil
food web. European Journal of Soil Biology 46, 97–104.
\item Van Den Hoogen, Johan, et al. "Soil nematode abundance and functional group
composition at a global scale." Nature 572.7768 (2019): 194-198.
\item Barnes, A.D., Jochum, M., Mumme, S., Haneda, N.F., Farajallah, A., Widarto, T.H.,
Brose, U., 2014. Consequences of tropical land use for multitrophic biodiversity and
ecosystem functioning. Nature Communications 5, 1–7.
\item De Ruiter, P.C., Van Veen, J.A., Moore, J.C., Brussaard, L., Hunt, H.W., 1993. Calculation
of nitrogen mineralization in soil food webs. Plant and Soil 157, 263–273.
}
}
\seealso{
The \code{nem_plot()} is used to visualize the calculation results and is a
generalized function for multiple classes including \code{\link{beta-class}},
\code{\link{beta2-class}}, \code{\link{compare-class}}, \code{\link{compare2-class}},
\code{\link{ef-class}}, \code{\link{ef2-class}}, \code{\link{funguild-class}},
\code{\link{funguild2-class}}, \code{\link{mf-class}}, \code{\link{mf2-class}},
\code{\link{ter-class}}, \code{\link{ter2-class}}, etc.
}
