% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nem_plot.R
\name{nem_plot,funguild-method}
\alias{nem_plot,funguild-method}
\title{Visualizing nematode functional guild data (single factor)}
\usage{
\S4method{nem_plot}{funguild}(object)
}
\arguments{
\item{object}{A \code{\link{funguild-class}} object.}
}
\value{
An \code{gg} or \code{ggplot} object.
}
\description{
The \code{\link{nem_plot}} function is generalized to the \code{\link{funguild-class}}
and is used to visualize the nematode functional guild data.
}
\details{
To facilitate code interpretation, it is recommended to use the pipe symbol
\code{\link{|>}} to connect functions:

\if{html}{\out{<div class="sourceCode">}}\preformatted{nem_plot <- nem |> calc_nemindex() |> calc_funguild(Treatments) |> nem_plot()
}\if{html}{\out{</div>}}
}
\examples{
nem <- read_nem2(tab = nemtab, tax = nemtax, meta = nemmeta)
nem_plot <- nem |>
            calc_nemindex() |>
            calc_funguild(Treatments) |>
            nem_plot()
nem_plot
}
\seealso{
The \code{nem_plot()} is used to visualize the calculation results and is a
generalized function for multiple classes including \code{\link{beta-class}},
\code{\link{beta2-class}}, \code{\link{compare-class}}, \code{\link{compare2-class}},
\code{\link{ef-class}}, \code{\link{ef2-class}}, \code{\link{funguild-class}},
\code{\link{funguild2-class}}, \code{\link{mf-class}}, \code{\link{mf2-class}},
\code{\link{ter-class}}, \code{\link{ter2-class}}, etc.
}
