% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_taxa.R
\name{plot_sites}
\alias{plot_sites}
\title{Plot sites on US map}
\usage{
plot_sites(
  data,
  id = NA_character_,
  alpha = 1,
  labels = TRUE,
  color_var = "package_id",
  shape_var = "package_id"
)
}
\arguments{
\item{data}{(list or tbl_df, tbl, data.frame) The dataset object returned by \code{read_data()}, a named list of tables containing the observation and taxon tables, or a flat table containing columns of the observation and location tables.}

\item{id}{(character) Identifier of dataset to be used in plot subtitles. Is automatically assigned when \code{data} is a dataset object containing the \code{id} field, or is a table containing the package_id column.}

\item{alpha}{(numeric) Alpha-transparency scale of data points. Useful when many data points overlap. Allowed values are between 0 and 1, where 1 is 100\% opaque. Default is 1.}

\item{labels}{(logical) Argument to show labels of each US state. Default is TRUE.}

\item{color_var}{(character) Name of column to use to assign colors to the points on the plot}

\item{shape_var}{(character) Name of column to use to assign shapes to the points on the plot}
}
\value{
(gg, ggplot) A gg, ggplot object if assigned to a variable, otherwise a plot to your active graphics device
}
\description{
Plot sites on US map
}
\details{
The \code{data} parameter accepts a range of input types but ultimately requires the 14 columns of the combined observation and location tables.
}
\examples{
\dontrun{
library(dplyr)
# Read a dataset of interest
dataset <- read_data("edi.193.5")

# Plot the dataset
plot_sites(dataset)

# Flatten dataset then plot
dataset \%>\%
 flatten_data() \%>\%
 plot_sites()

# Download a NEON dataset
dataset2 <- read_data(
 id = "neon.ecocomdp.20120.001.001",
 site= c('COMO','LECO'), 
 startdate = "2017-06",
 enddate = "2021-03",
 token = Sys.getenv("NEON_TOKEN"), # option to use a NEON token
 check.size = FALSE)

# Combine the two datasets and plot. This requires the datasets be first
# flattened and then stacked.
flattened_data1 <- dataset \%>\% flatten_data()
flattened_data2 <- dataset2 \%>\% flatten_data()
stacked_data <- bind_rows(flattened_data1,flattened_data2)
plot_sites(stacked_data)
}

# Plot the example dataset
plot_sites(ants_L1)

}
