% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeatmap.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Plot heatmap.}
\usage{
plotHeatmap(x, value.name = "Value", show.values = FALSE)
}
\arguments{
\item{x}{[\code{matrix} | \code{list[matrix]}]\cr
Either a matrix or a list of matrizes.}

\item{value.name}{[\code{character(1)}]\cr
Name for the values represented by the matrix.
Internally, the matrix is transformed into a \code{data.frame}
via \code{\link[reshape2]{melt}} in order to obtain a format
which may be processed by \code{\link[ggplot2]{ggplot}} easily.
Default is \dQuote{Value}.}

\item{show.values}{[\code{logical(1L)}]\cr
Should the values be printed within the heatmap cells?
Default is \code{FALSE}.}
}
\value{
[\code{\link[ggplot2]{ggplot}}] ggplot object.
}
\description{
Given a matrix or list of matrizes \code{x} this function
visualizes each matrix with a heatmap.
}
\examples{
# simulate two (correlation) matrizes
x = matrix(runif(100), ncol = 10)
y = matrix(runif(100), ncol = 10)
\dontrun{
pl = plotHeatmap(x)
pl = plotHeatmap(list(x, y), value.name = "Correlation")
pl = plotHeatmap(list(MatrixX = x, MatrixY = y), value.name = "Correlation")
}
}
