% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_Ex.R
\name{calculate_Ex}
\alias{calculate_Ex}
\title{Exploitation of the thermal environment}
\usage{
calculate_Ex(te, tb, tset_low, tset_up)
}
\arguments{
\item{te}{A vector containing operative temperatures. These data should be 
in the same time unit as the tb data.}

\item{tb}{A vector containing body temperature measurements.}

\item{tset_low}{Lower boundary of a species or population set-point range
that was determined through thermal preference trials in a temperature 
gradient. This may be a named double vector containing the lower boundary 
value, or simply the value itself.}

\item{tset_up}{Upper boundary of the set-point range.}
}
\value{
Ex index, indicating thermal exploitation of the environment during a 
user-determined period of time.
}
\description{
This function determines the extent to which organisms exploit their thermal 
environment (indexed by Ex) following Christian and Weavers (1996). Ex is 
given by the amount of time when field body temperatures (Tb) are within the 
set-point range, relative to the total amount of time during which this 
could have been possible as indicated by operative temperatures (Te). The 
higher the Ex value, the more an organism exploits its thermal environment 
when the environment is permissive.
The user-supplied vectors containing Te and Tb data are assumed to use the 
same time unit.
}
\examples{
te <- na.omit(ichalp[,"te"])
tb <- na.omit(ichalp[,"tb"])
Ex <- calculate_Ex(te, tb, 14.44, 18.33)

}
\references{
Christian, K. A., & Weavers, B. W. (1996). Thermoregulation of monitor 
lizards in Australia: an evaluation of methods in thermal biology. 
Ecological monographs, 66(2), 139-157.
}
