% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.r
\name{profile.eicm}
\alias{profile.eicm}
\title{Likelihood profiles for EICMs}
\usage{
\method{profile}{eicm}(
  fitted,
  all.pars = TRUE,
  parmatrix,
  species,
  parameter,
  step = 0.3,
  ncores = parallel::detectCores(),
  alpha = 0.01,
  ...
)
}
\arguments{
\item{fitted}{the fitted EICM model.}

\item{all.pars}{logical. Compute for all model parameters?}

\item{parmatrix}{if all.pars=FALSE, in which matrix is the parameter of interest, "env" or "sp"?}

\item{species}{if all.pars=FALSE, in which row of \code{parmatrix} is the parameter of interest?}

\item{parameter}{if all.pars=FALSE, in which column of \code{parmatrix} is the parameter of interest?}

\item{step}{the step increments/decrements at which to compute the likelihood profile points.}

\item{ncores}{the number of CPU cores to use when computing profiles for all parameters.}

\item{alpha}{highest significance level that will be guaranteed for this profile.}

\item{...}{additional argument(s) for methods}
}
\value{
The same model object updated with a new \code{profile} component.
}
\description{
Computes the profile (penalized) likelihood for all (or only one) estimated parameters in a EICM model.
}
\details{
Likelihod profiles will use the same regularization settings that were used in model fitting.
}
\note{
Confidence intervals should \strong{not} be computed on a model whose terms have been selected.

This function is optimized for computing profiles of multiple parameters simultaneously (in parallel).
}
\examples{
\donttest{
# load the included parameterized model
data(truemodel)

# realize the model
occurrences <- predict(truemodel, nrepetitions=1)

# fit the model without species interactions
fitted <- eicm(occurrences, n.latent=2, mask.sp=0, do.selection=FALSE)$fitted.model

# compute likelihood profiles for all parameters
fitted <- profile(fitted, ncores=2)

# plot the first 9 profiles
par(mfrow=c(3, 3))
dummy <- lapply(fitted$profile[1:9], plot)
}
}
