% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/media.inei.R
\name{media.inei}
\alias{media.inei}
\title{Media}
\usage{
media.inei(
  x,
  base,
  estratos = NULL,
  combinarestratos = FALSE,
  dividirperiodos = FALSE,
  ruralidad = 6:8,
  pesos = NULL,
  var = c("insesgado"),
  decimales = NULL
)
}
\arguments{
\item{x}{una cadena de caracteres con los nombres de las variables a estimar.}

\item{base}{una base leída con \code{\link{leer.inei}} o \code{\link{leer.inei.web}} en forma de tibble
o en forma de lista.}

\item{estratos}{una cadena de caracteres con los nombres de las variables que deben ser consideradas como estratos.
Además se puede usar (sólo en las bases de la ENAHO) \code{"area"} y \code{"region"}, con las que se calcularán los resultados para los
estratos urbano y rural, y para cada región.}

\item{combinarestratos}{un valor lógico que indica si debe calcularse también la combinación entre estratos.
Por ejemplo, si los estatos son \code{"area"} y \code{"region"}, se estimará también para cada área de
cada región.}

\item{dividirperiodos}{un valor lógico que indica si los resultados deben ser separados por período.}

\item{ruralidad}{un vector numérico que indica que valores de la variable \code{"ESTRATO"} deben ser considerados
rurales. Usualmente del 6 al 8.}

\item{pesos}{una cadena de caracteres con el nombre de la(s) variable(s) que representan los pesos.
Si es \code{NULL} las proporciones se estiman sin pesarlas.}

\item{var}{una cadena de texto que indica el método a usar para la varianza:
\code{"insesgado"} calcula la estimación insesgada (n-1);
\code{"MV"} calcula la estimación de máxima verosimilitud.}

\item{decimales}{un valor numérico que indica cuántos decimales se necesitan. Si es \code{NULL} no se redondea.}
}
\value{
un data frame o una lista.
}
\description{
Estima medias de variables en bases leídas con \code{\link{leer.inei}} o
\code{\link{leer.inei.web}}.
}
\examples{
directorio = system.file("extdata", package = "enaho")
leido <- leer.inei(modulo = 37, periodos = 2011, directorio = directorio, tipo = c("t1","t2"))
media.inei(x = c("P7061"),base = leido,pesos = "FACTRIM")

}
