% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{validate_config}
\alias{validate_config}
\title{Validate a configuration file}
\usage{
validate_config(config)
}
\arguments{
\item{config}{configuration object from config::get()}
}
\value{
Called for its side-effects. Prints findings from validation checks.
}
\description{
A helper function to help troubleshoot common problems that can occur when
building your configuration file.
}
\examples{
# temp location to store configuration files
tmpdir <- tempdir()
print(tmpdir)

# Each path only points to one location, i.e. there is no hierarchy for a path
no_hierarchy <- 'default:
  paths:
    data: "/demo/DEV/username/project1/data"
    output: "/demo/DEV/username/project1/output"
    programs: "/demo/DEV/username/project1/programs"'

writeLines(no_hierarchy, file.path(tmpdir, "no_hierarchy.yml"))

validate_config(config::get(file = file.path(tmpdir, "no_hierarchy.yml")))

# A path can point to multiple locations, i.e. there is a hierarchy
hierarchy <- "default:
  paths:
    data: !expr list(DEV = '/demo/DEV/username/project1/data',
                     PROD = '/demo/PROD/project1/data')
    output: !expr list(DEV = '/demo/DEV/username/project1/output',
                       PROD = '/demo/PROD/project1/output')
    programs: !expr list(DEV = '/demo/DEV/username/project1/programs',
                         PROD = '/demo/PROD/project1/programs')
    envsetup_environ: !expr Sys.setenv(ENVSETUP_ENVIRON = 'DEV'); 'DEV'"

writeLines(hierarchy, file.path(tmpdir, "hierarchy.yml"))

validate_config(config::get(file = file.path(tmpdir, "hierarchy.yml")))

# A hierarchy is present for paths, but they are not named
hierarchy_no_names <- "default:
  paths:
    data: !expr list('/demo/DEV/username/project1/data', '/demo/PROD/project1/data')
    output: !expr list('/demo/DEV/username/project1/output', '/demo/PROD/project1/output')
    programs: !expr list('/demo/DEV/username/project1/programs', '/demo/PROD/project1/programs')
    envsetup_environ: !expr Sys.setenv(ENVSETUP_ENVIRON = 'DEV'); 'DEV'"


writeLines(hierarchy_no_names, file.path(tmpdir, "hierarchy_no_names.yml"))

validate_config(config::get(file = file.path(tmpdir, "hierarchy_no_names.yml")))


# No paths are specified
no_paths <- "default:
  autos:
    my_functions: '/demo/PROD/project1/R'"

writeLines(no_paths, file.path(tmpdir, "no_paths.yml"))

validate_config(config::get(file = file.path(tmpdir, "no_paths.yml")))
}
