% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence_to_R.R
\name{incidence_to_R}
\alias{incidence_to_R}
\title{Estimate Rt using EpiEstim}
\usage{
incidence_to_R(incidence, generation.interval, prm.R)
}
\arguments{
\item{incidence}{Data frame. Estimated incidence. Must include at least
\code{date}, \code{I}, and \code{t} columns.}

\item{generation.interval}{List. Parameters for a single generation interval distribution, as generated by \code{\link[=sample_a_dist]{sample_a_dist()}}.}

\item{prm.R}{List. Settings for the ensemble when calculating Rt.
Elements include:
\itemize{
\item \code{iter}: Integer. Number of iterations for the Rt ensemble
\item \code{CI}: Numeric between 0 and 1. Confidence interval width for Rt
estimates after sampling uncertain distributions.
\item \code{window}: Integer. Number of days defining the window of data used by
\code{EpiEstim} to estimate Rt. If \code{NULL}, will default to 7.
\item \code{config.EpiEstim}: (optional) configuration for \code{EpiEstim} defined via
\code{\link[EpiEstim:make_config]{EpiEstim::make_config()}}. If \code{NULL}, will use default config from
\code{EpiEstim}.
}}
}
\description{
Estimate Rt using EpiEstim
}
\seealso{
\code{\link[=def_dist]{def_dist()}}

\code{\link[EpiEstim:make_config]{EpiEstim::make_config()}}
}
\keyword{internal}
