% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc.R
\name{effect_sizes}
\alias{effect_sizes}
\title{Generate effect size data frame from other data}
\usage{
effect_sizes(
  data,
  ...,
  fun,
  es.type = c("d", "g", "or", "logit", "r", "f", "eta", "cox.or", "cox.log")
)
}
\arguments{
\item{data}{A data frame with columns that contain the values that are passed
to one of the \pkg{esc}-functions.}

\item{...}{Named arguments. The name (left-hand side) is the name of one of
\pkg{esc} functions' argument, the argument (right-hand side) is the
name of the column in \code{data} that holds the data values.
See 'Examples'.}

\item{fun}{Name of one of the \pkg{esc}-functions, as string, where arguments
in \code{...} are passed to. May either be the full function name
(like \code{"esc_t"} or \code{"esc_2x2"}) or the funcion name
\emph{without} the suffix \code{"esc_"} (like \code{"t"} or \code{"2x2"}).}

\item{es.type}{Type of effect size that should be returned.
\describe{
  \item{\code{"d"}}{returns standardized mean difference effect size \code{d}}
  \item{\code{"f"}}{returns effect size Cohen's \code{f}}
  \item{\code{"g"}}{returns adjusted standardized mean difference effect size Hedges' \code{g}}
  \item{\code{"or"}}{returns effect size as odds ratio}
  \item{\code{"cox.or"}}{returns effect size as Cox-odds ratio (see \code{\link{convert_d2or}} for details)}
  \item{\code{"logit"}}{returns effect size as log odds}
  \item{\code{"cox.log"}}{returns effect size as Cox-log odds (see \code{\link{convert_d2logit}} for details)}
  \item{\code{"r"}}{returns correlation effect size \code{r}}
  \item{\code{"eta"}}{returns effect size eta squared}
}}
}
\value{
A data frame with the effect sizes computed for all data from \code{data}.
}
\description{
This method computes any effect size from raw values from a data
             frame. Convenient method to compute multiple effect sizes at once,
             when the required information to calculate effects sizes are
             stored in a table (i.e. data frame).
}
\details{
This function rowwise iterates \code{data} and calls the function named
        in \code{fun} for the values taken from each row of \code{data}.
        The column names in \code{data} that contain the necessary values to compute
        the effect sizes should be passed as unquoted value for the arguments.
        The argument names should match those arguments for the esc-function
        that should be called from within \code{effect_sizes()}.
        \cr \cr
        Example: \cr
        If you want to compute effect sizes from chi-squared values, you
        would call \code{esc_chisq()}. This function name is used for the
        \code{fun}-argument: \code{fun = "esc_chisq"}. \code{esc_chisq()}
        requires one of \code{chisq} or \code{p} as arguments, and \code{totaln}.
        Now \code{data} must have columns with values for either \code{chisq}
        or \code{p}, and \code{effect_sizes()} automatically selects the
        first non-missing value from \code{data} (see 'Examples').
}
\examples{
tmp <- data.frame(
  tvalue = c(3.3, 2.9, 2.3),
  n = c(250, 200, 210),
  studyname = c("Study 1", "Study 2", "Study 3")
)
effect_sizes(tmp, t = tvalue, totaln = n, study = studyname, fun = "esc_t")

# missing effect size results are dropped,
# shorter function name, calls "esc_t()"
tmp <- data.frame(
  tvalue = c(3.3, 2.9, NA, 2.3),
  n = c(250, 200, 210, 210),
  studyname = c("Study 1", "Study 2", NA, "Study 4")
)
effect_sizes(tmp, t = tvalue, totaln = n, study = studyname, fun = "t")


tmp <- data.frame(
  coefficient = c(0.4, 0.2, 0.6),
  se = c(.15, .1, .2),
  treat = c(50, 60, 50),
  cntrl = c(45, 70, 40),
  author = c("Smith 2000", "Smith 2010 2", "Smith 2012")
)
effect_sizes(tmp, beta = coefficient, sdy = se, grp1n = treat, grp2n = cntrl,
    study = author, fun = "esc_beta", es.type = "or")

# the "esc_chisq" function requires *either* the chisq-argument *or*
# the pval-argument. If at least one of these values is present,
# effect size can be calculated. You can specify both arguments,
# and the first non-missing required value from "data" is taken.
tmp <- data.frame(
  chisqquared = c(NA, NA, 3.3, NA, 2.9),
  pval = c(.003, .05, NA, .12, NA),
  n = c(250, 200, 210, 150, 180),
  studyname = c("Study 1", "Study 2", "Study 3", "Study 4", "Study 5")
)
effect_sizes(tmp, chisq = chisqquared, p = pval, totaln = n,
             study = studyname, fun = "esc_chisq")

# if all required information are missing, data will be removed
tmp <- data.frame(
  chisqquared = c(NA, NA, 3.3, NA, NA),
  pval = c(.003, .05, NA, .12, NA),
  n = c(250, 200, 210, 150, 180),
  studyname = c("Study 1", "Study 2", "Study 3", "Study 4", "Study 5")
)
effect_sizes(tmp, chisq = chisqquared, p = pval, totaln = n,
             study = studyname, fun = "chisq")


}
