% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{continue}
\alias{continue}
\title{Should this dose-finding experiment continue?}
\usage{
continue(x, ...)
}
\arguments{
\item{x}{Object of type \code{\link{selector}}.}

\item{...}{Extra args are passed onwards.}
}
\value{
logical
}
\description{
Should this dose-finding experiment continue? Or have circumstances prevailed
that dictate this trial should stop? This method is critical to the automatic
calculation of statistical operating characteristics and dose-pathways. You
add stopping behaviours to designs using calls like \code{\link{stop_at_n}}
and \code{\link{stop_when_too_toxic}}.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
model1 <- get_dfcrm(skeleton = skeleton, target = target)
fit1 <- model1 \%>\% fit('1NNN 2NTN')
fit1 \%>\% continue()

model2 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  stop_at_n(n = 6)
fit2 <- model2 \%>\% fit('1NNN 2NTN')
fit2 \%>\% continue()
}
