% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_calcs.R
\name{binned_es}
\alias{binned_es}
\title{Calculate binned effect sizes}
\usage{
binned_es(
  data,
  formula,
  ref_group = NULL,
  qtile_groups = 3,
  es = "g",
  rename = TRUE
)
}
\arguments{
\item{data}{The data frame used for estimation - ideally structured in a tidy 
format.}

\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups. Additional variables 
can be included with \code{+} to produce separate estimates by the secondary 
or tertiary variables of interest (e.g., \code{out ~ group + characteristic1 
+ characteristic2}).}

\item{ref_group}{Optional. A character vector or forumla listing the 
reference group levels for each variable on the right hand side of the 
formula, supplied in the same order as the formula. Note that if using the
formula version, levels that are numbers, or include hyphens, spaces, etc., 
should be wrapped in back ticks (e.g., 
\code{ref_group = ~ Active + `Non-FRL`}, or \code{ref_group = ~`8`}). When 
in doubt, it is safest to use the back ticks, as they will not interfere 
with anything if they are not needed. See examples below for more details.}

\item{qtile_groups}{The number of quantile bins to split the data by and 
calculate effect sizes. Defaults to 3 bins (lower, middle, upper).}

\item{es}{The effect size to calculate. Currently the only options are 
"d" or "g".}

\item{rename}{Logical. Should the column names be relabeled according to
the reference and focal groups. Defaults to \code{TRUE}.}
}
\value{
A data frame with the corresponding effect sizes.
}
\description{
Calculate binned effect sizes
}
