% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safety_summary_adam.R
\name{safety_summary_adam}
\alias{safety_summary_adam}
\title{Calculate frequency tables based on ADaM data.}
\usage{
safety_summary_adam(
  adsl,
  adae,
  freq_threshold = 0,
  na.action = na.fail,
  related_terms = c("POSSIBLE", "PROBABLE", "DEFINITELY", "Y")
)
}
\arguments{
\item{adsl}{ADaM Subject-level analysis data set}

\item{adae}{ADaM Adverse Event data set}

\item{freq_threshold}{a value on a percentage scale at which to remove events if the incidence falls below. Defaults to 0}

\item{na.action}{a function that indicates what should happen if the data contain missing values. The default is \code{\link{na.fail}}  as both repositories will not accept any missing values in the upload. Alternatives could be \code{\link{na.omit}}, \code{\link{na.exclude}}, or \code{\link{na.pass}}.}

\item{related_terms}{The set of terms used in \code{adae$AEREL} to identify related events.}
}
\value{
a list of three data frames: GROUP, SERIOUS, NON_SERIOUS. Each contains the summary statistics required by EudraCT, and is suitable for export.
}
\description{
Calculate frequency tables based on ADaM data.
}
\details{
It is worth highlighting that the CDISC standards need to be followed. 
There must be an \code{ARM} variable in the \code{adsl} data. 
Screen failures must be filtered out.  It is up to the user to manipulate the 
input data as required.
}
\examples{

safety_summary_adam(
 pharmaverseadam::adsl |> dplyr::filter(ARM != "Screen Failure"), 
 pharmaverseadam::adae)


}
\seealso{
\code{\link{safety_summary}} \code{\link{eudract_convert}} \code{\link{simple_safety_xml}}
}
