% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva.R
\name{eva}
\alias{eva}
\title{Model statistical evaluation}
\usage{
eva(
  mo,
  ob,
  rname = site,
  table = NULL,
  site = "ALL",
  wd = FALSE,
  fair = NULL,
  cutoff = NA,
  cutoff_NME = NA,
  no_tz = FALSE,
  nobs = 8,
  eval_function = stat,
  select_time,
  time = "date",
  remove_ch = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{mo}{data.frame with model data}

\item{ob}{data.frame with observation data}

\item{rname}{row name of the output (default is site argument)}

\item{table}{data.frame to append the results}

\item{site}{name of the stations or "ALL" (default), see notes}

\item{wd}{default is FALSE, see notes}

\item{fair}{model data.frame (or list of names) to perform a fair comparison, see notes}

\item{cutoff}{minimum (optionally the maximum) valid value for observation}

\item{cutoff_NME}{minimum (optionally the maximum) valid value for observation for NME}

\item{no_tz}{ignore tz from input (force GMT)}

\item{nobs}{minimum number of valid observations, default is 8}

\item{eval_function}{evaluation function (default is stat)}

\item{select_time}{select the observation (ob) using time from model (mo) data.frame}

\item{time}{name of the time column (containing time in POSIXct)}

\item{remove_ch}{remove special characters on column names}

\item{verbose}{display additional information}

\item{...}{arguments to be passing to stats and plot}
}
\value{
data.frame with statistical values from stat or cate functions.
}
\description{
Statistical (or categorical) evaluation from 2 data.frames. The input data.frames (model and observation)
must contain a "date" column (containing POSIXlt). The function perform some simple case tests and
perform the time pairing of observations and model data and can calculate the statistical evaluation or
categorical evaluation.
}
\note{
fair can be a data.frame or a character string to be used for the analysis, alternatively the function %IN% can be used: model_d01 %IN% model_d02 instead.

for wind direction a rotation of 360 (or -360) is applied to minimize the wind direction difference.

If site == 'ALL' (default) all the columns from observations are combined in one column
(same for observation) and all the columns are evaluated together.

Special thanks to Kiarash and Libo to help to test the wind direction option.
}
\examples{
model <- readRDS(paste0(system.file("extdata",package="eva3dm"),
                        "/model.Rds"))
obs   <- readRDS(paste0(system.file("extdata",package="eva3dm"),
                        "/obs.Rds"))

# if there is no observed data
# the function return an empty row
table <- eva(mo = model, ob = obs, site = "VVIbes")
print(table)

# if the site are not in the input data frame a message is displayed
# and the function return an empty row
table <- eva(mo = model, ob = obs, site = "Ibirapuera")
print(table)

# calculating statistical with a few observed values
table <- eva(mo = model, ob = obs, site = "Americana")
print(table)

# calculating categorical (using 2 for threshold) with a few observed values
table <- eva(mo = model, ob = obs, site = "Americana",
             eval_function = cate, threshold = 2)
print(table)

# calculating categorical (using 2 for threshold) with a few observed values
table <- eva(mo = model, ob = obs, site = "Americana",
             eval_function = cate, threshold = 10)
print(table)

# customizing the evaluation function: inclusion of p.value from stats::cor.test()
stat_p <- function(x, y, ...){
  table         <- eva3dm::stat(x, y, ...)
  cor.result    <- stats::cor.test(x, y, ... )
  table$p.value <- cor.result$p.value
  table         <- table[,c(1:4,12,5:11)]
  return(table)
}

table <- eva(mo = model, ob = obs, site = "Americana",eval_function = stat_p)
print(table)

}
\seealso{
\code{\link{stat}} for additional information about the statistical evaluation and \code{\link{cate}} for categorical evaluation.
}
