% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_evzinb.R
\name{predict.evinb}
\alias{predict.evinb}
\title{Predictions from evinb object}
\usage{
\method{predict}{evinb}(
  object,
  newdata = NULL,
  type = c("harmonic", "explog", "counts", "pareto_alpha", "evinf", "count_state",
    "states", "all", "quantile"),
  pred = c("original", "bootstrap_median", "bootstrap_mean"),
  quantile = NULL,
  confint = FALSE,
  conf_level = 0.9,
  multicore = FALSE,
  ncores = NULL,
  ...
)
}
\arguments{
\item{object}{An evinb object for which to produce predicted values}

\item{newdata}{Optional new data (tibble) to produce predicted values from}

\item{type}{Character string, 'harmonic' for the harmonic mean and 'explog' for exponentiated expected log, 'counts' for predicted count of the negative binomial component, 'pareto_alpha' for the predicted pareto alpha value, 'states' for the predicted component states (prior), 'count_state' for predicted probability of the count state, 'evinf' for predicted probability of the pareto state, 'all' for all predicted values, and 'quantile' for quantile prediction.}

\item{pred}{Type of prediction to be used, defaults to the original prediction from the fitted model, with alternatives being the bootstrapped median or mean. Note that bootstrap mean may yield infinite values, especially when doing quantile prediction}

\item{quantile}{Quantile for which to produce quantile prediction}

\item{confint}{Should confidence intervals be made for the predictions? Note: only available for vector type predictions and not 'states' and 'all'.}

\item{conf_level}{What confidence level should be used for confidence intervals}

\item{multicore}{Should multicore be used when calculating quantile prediction? Often it is enough to run quantile prediction on a single core, but in cases of large data or very skewed distributions it may be useful to run multicore}

\item{ncores}{Number of cores to be used for multicore.}

\item{...}{Other arguments passed to predict function}
}
\value{
A vector of predicted values for type 'harmonic', 'explog', 'counts', 'pareto_alpha','evinf', 'count_state', and 'quantile' or a tibble of predicted values for type 'states' and 'all' or if confint=T
}
\description{
Predictions from evinb object
}
\examples{
data(genevzinb2)
model <- evinb(y~x1+x2+x3,data=genevzinb2, n_bootstraps = 10)
predict(model)
predict(model, type='all') # Getting all of the available predicted values

}
