% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{nrs}
\alias{nrs}
\alias{nrs.default}
\alias{nrs.binary}
\title{Number Right Score}
\usage{
nrs(U, na = NULL, Z = NULL, w = NULL)

\method{nrs}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{nrs}{binary}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A numeric vector containing the Number-Right Score for each examinee.
The score represents the weighted sum of correct answers, where:
\itemize{
\item Maximum score is the sum of all item weights
\item Minimum score is 0
\item Missing responses do not contribute to the score
}
}
\description{
The Number-Right Score (NRS) function calculates the weighted sum of correct
responses for each examinee. This function is applicable only to binary
response data.

For each examinee, the score is computed as:
\deqn{NRS_i = \sum_{j=1}^J z_{ij}u_{ij}w_j}
where:
\itemize{
\item \eqn{z_{ij}} is the missing response indicator (0/1)
\item \eqn{u_{ij}} is the response (0/1)
\item \eqn{w_j} is the item weight
}
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# using sample dataset
nrs(J15S500)
}
