% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seager.R
\name{seager}
\alias{seager}
\title{The Seager 2013 equation}
\usage{
seager(Ns, fQ, fHZ, fo, fL, fS)
}
\arguments{
\item{Ns}{number of stars}

\item{fQ}{fraction of quiet stars}

\item{fHZ}{fraction with rocky planets within the habitable zone.}

\item{fo}{fraction of observable planets.}

\item{fL}{fraction of planets with life.}

\item{fS}{fraction of planets with detectable gaseous signatures.}
}
\value{
N number of planets with signs of life.
}
\description{
An alternative to the Drake 1961 equation. The Seager equation considers the detection biogenic gases in the estimation of planets harboring life.
}
\examples{
seager(Ns=.45, fQ=0.5, fHZ=0.2, fo=0.05, fL=0.5, fS=500)
}
\references{
https://www.cfa.harvard.edu/events/2013/postkepler/Exoplanets_in_the_Post_Kepler_Era/Program_files/Seager.pdf

The Drake Equation Revisited: Interview with Planet Hunter Sara Seager Devin Powell, Astrobiology Magazine 4 September 2013.
}
