% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIC.R
\name{DIC}
\alias{DIC}
\alias{DIC.evmm}
\title{Deviance Information Criterion}
\usage{
DIC(x, ...)

\method{DIC}{evmm}(x, ...)
}
\arguments{
\item{x}{the output of a model estimated with \code{extrememix}}

\item{...}{additional arguments for compatibility.}
}
\value{
The DIC of a model estimated with \code{extrememix}
}
\description{
Computation of the DIC for an extreme value mixture model
}
\details{
Let \eqn{y} denote a dataset and \eqn{p(y|\theta)} the likelihood of a parametric model with parameter \eqn{\theta}. The deviance is defined as \eqn{D(\theta)= -2\log p(y|\theta)}. The deviance information criterion (DIC) is defined as \deqn{DIC = D(\hat\theta) + 2p_D,} where \eqn{\hat\theta} is the posterior estimate of \eqn{\theta} and \eqn{p_D} is referred to as the effective number of parameters and defined as \deqn{E_{\theta|y}(D(\theta)) - D(\hat\theta).} Models with a smaller DIC are favored.
}
\examples{
DIC(rainfall_ggpd)

}
\references{
Spiegelhalter, David J., et al. "Bayesian measures of model complexity and fit." Journal of the Royal Statistical Society: Series B 64.4 (2002): 583-639.
}
\seealso{
\code{\link{WAIC}}
}
