% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-file_index.R
\name{file_index_read}
\alias{file_index_read}
\title{Read, source and open objects from an index of files}
\usage{
file_index_read(
  index,
  file_path = "^",
  file_name = "^",
  extension = "^",
  file_type = "^",
  assign = FALSE,
  .envir = parent.frame()
)
}
\arguments{
\item{index}{The index (tibble) of a folder with file locations and metadata,
either previously generated by file_index_create() or created from folder.}

\item{file_path}{A character string specifying a file path to search by.
Can be the full string or substring (matching by regex is supported)}

\item{file_name}{A character string a file name to search by.
Can be the full string or substring (matching by regex is supported).}

\item{extension}{A character string a file extension to search by.
Can be the full string or substring (matching by regex is supported).}

\item{file_type}{A character string a file type to search by.
Can be the full string or substring (matching by regex is supported).}

\item{assign}{If TRUE, the name is automatically assigned from the name
of the object read.}

\item{.envir}{The environment to use. parent.frame() by default}
}
\value{
R objects generated in the environment or R scripts. R object names are
created automatically from their file names. Otherwise return messages
indicating what objects were created, or files opened, and if any troubles
occurred.
}
\description{
Reads all files from a file index tibble as R objects to generate in the
environment or R scripts to be sourced. Any other file types will be opened
in browser (html files) or in environment. If no index tibble is provided,
the function creates one from the working directory. (matching by regex is
supported).
}
\details{
for each file selected,
xlsx files will be read using the function \code{\link[=read_excel_allsheets]{read_excel_allsheets()}},
csv files will be read using the function \code{\link[=read_csv_any_formats]{read_csv_any_formats()}},
spss and sav files will be read using the function \code{\link[haven:read_spss]{haven::read_spss()}},
dta files will be read using the function \code{\link[haven:read_dta]{haven::read_dta()}},
sas7bdat and sas files will be read using the function \code{\link[haven:read_sas]{haven::read_sas()}},
R scripts, Rmd and md files be read using the function \code{\link[=readLines]{readLines()}},
The whole files will be created in a list, which name is the name of the
file.
}
\examples{
\dontrun{

index <- file_index_create(tempdir())
file_index_read(index, file_name = my_file_name)

}

}
\seealso{
\code{\link[=read_excel_allsheets]{read_excel_allsheets()}}, \code{\link[=read_csv_any_formats]{read_csv_any_formats()}}, \code{\link[haven:read_spss]{haven::read_spss()}},
\code{\link[haven:read_dta]{haven::read_dta()}}, \code{\link[haven:read_sas]{haven::read_sas()}}, \code{\link[=readLines]{readLines()}}
}
