% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitFfmDT.R
\name{fitFfmDT}
\alias{fitFfmDT}
\title{fitFfmDT}
\usage{
fitFfmDT(
  ffMSpecObj,
  fit.method = c("LS", "WLS", "Rob", "W-Rob"),
  resid.scaleType = c("StdDev", "EWMA", "RobustEWMA", "GARCH"),
  lambda = 0.9,
  GARCH.params = list(omega = 0.09, alpha = 0.1, beta = 0.81),
  GARCH.MLE = FALSE,
  lmrobdet.control.para.list = lmrobdet.control(),
  ...
)
}
\arguments{
\item{ffMSpecObj}{a specFFm object}

\item{fit.method}{method for estimating factor returns; one of "LS", "WLS"
"ROB" or "W-ROB". See details. Default is "LS".}

\item{resid.scaleType}{one of 4 choices "StdDev","EWMA","RobustEWMA", "GARCH"}

\item{lambda}{the ewma parameter}

\item{GARCH.params}{list containing GARCH parameters omega, alpha, and beta. 
Default values are (0.09, 0.1, 0.81) respectively. Valid only when 
\code{GARCH.MLE} is set to \code{FALSE}. Estimation outsourced to the
 rugarch package, please load it first.}

\item{GARCH.MLE}{boolean input (TRUE|FALSE), default value = \code{FALSE}. This
argument allows one to choose to compute GARCH parameters by maximum 
likelihood estimation. Estimation outsourced to the rugarch
package, please load it.}

\item{lmrobdet.control.para.list}{list of parameters to pass to lmrobdet.control().
Sets tuning parameters for the MM estimator implemented in lmrobdetMM of the
RobStatTM package. See \code{\link[RobStatTM]{lmrobdetMM}}.}

\item{...}{additional pass through arguments}
}
\value{
\code{fitFfm} returns a list with two object of class \code{"data.table"}
The first reg.listDT is object of class \code{"data.table"} is a list containing the following
components:
\item{DATE}{length-Time vector of dates.}
\item{id}{length-N vector of asset id's for each date.}
\item{reg.list}{list of fitted objects that estimate factor returns in each
time period. Each fitted object is of class \code{lm} if
\code{fit.method="LS" or "WLS"}, or, class \code{lmrobdetMM} if
\code{fit.method="Rob" or "W-Rob"}.}
The second betasDT is object of class \code{"data.table"} is a list containing the following
components:
\item{DATE}{length-Time vector of dates.}
\item{R_matrix}{The K+1 by K restriction matrix where K is the number of categorical variables for each date.}
}
\description{
This function fits a fundamental factor model
}
\details{
this function operates on the data inside the specObj fits a fundamental factor
model to the data
}
\seealso{
\code{\link{specFfm}} for information on the definition of the specFfm object.
}
