% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.Tsfm.control.R
\name{fitTsfm.control}
\alias{fitTsfm.control}
\title{List of control parameters for \code{fitTsfm}}
\usage{
fitTsfm.control(
  decay = 0.95,
  weights,
  model = TRUE,
  x = FALSE,
  y = FALSE,
  qr = TRUE,
  nrep = NULL,
  bb = 0.5,
  efficiency = 0.95,
  family = "mopt",
  tuning.psi,
  tuning.chi,
  compute.rd = FALSE,
  corr.b = TRUE,
  split.type = "f",
  initial = "S",
  max.it = 100,
  refine.tol = 1e-07,
  rel.tol = 1e-07,
  refine.PY = 10,
  solve.tol = 1e-07,
  trace.lev = 0,
  psc_keep = 0.5,
  resid_keep_method = "threshold",
  resid_keep_thresh = 2,
  resid_keep_prop = 0.2,
  py_maxit = 20,
  py_eps = 1e-05,
  mscale_maxit = 50,
  mscale_tol = 1e-06,
  mscale_rho_fun = "bisquare",
  scope,
  scale,
  direction,
  steps = 1000,
  k = 2,
  nvmin = 1,
  nvmax = 8,
  force.in = NULL,
  force.out = NULL,
  method,
  really.big = FALSE,
  type,
  normalize = TRUE,
  eps = .Machine$double.eps,
  max.steps,
  plot.it = FALSE,
  lars.criterion = "Cp",
  K = 10
)
}
\arguments{
\item{decay}{a scalar in (0, 1] to specify the decay factor for "DLS". 
Default is 0.95.}

\item{weights}{an optional vector of weights to be used in the fitting 
process for \code{fit.method="LS","Robust"}, or 
\code{variable.selection="subsets"}. Should be \code{NULL} or a numeric 
vector. The length of \code{weights} must be the same as the number of 
observations. The weights must be nonnegative and it is strongly 
recommended that they be strictly positive.}

\item{model, x, y, qr}{logicals passed to \code{lm} for 
\code{fit.method="LS"}. If \code{TRUE} the corresponding components of the 
fit (the model frame, the model matrix, the response, the QR decomposition) 
are returned.}

\item{nrep}{the number of random subsamples to be drawn for 
\code{fit.method="Robust"}. If the data set is small and "Exhaustive" 
resampling is being used, the value of \code{nrep} is ignored.}

\item{bb}{tuning constant (between 0 and 1/2) for the M-scale used to compute the initial S-estimator. It
determines the robustness (breakdown point) of the resulting MM-estimator, which is
\code{bb}. Defaults to 0.5.}

\item{efficiency}{desired asymptotic efficiency of the final regression M-estimator. Defaults to 0.85.}

\item{family}{string specifying the name of the family of loss function to be used (current valid
options are "bisquare", "optimal" and "modopt" from the RobStatTM package). Incomplete entries will be matched to
the current valid options.}

\item{tuning.psi}{tuning parameters for the regression M-estimator computed with a rho function
as specified with argument \code{family}. If missing, it is computed inside \code{lmrobdet.control} to match
the value of \code{efficiency} according to the family of rho functions specified in \code{family}.
Appropriate values for \code{tuning.psi} for a given desired efficiency for Gaussian errors
can be constructed using the functions \code{\link[RobStatTM]{bisquare}}, \code{\link[RobStatTM]{mopt}} and \code{\link[RobStatTM]{opt}}.}

\item{tuning.chi}{tuning constant for the function used to compute the M-scale
used for the initial S-estimator. If missing, it is computed inside \code{lmrobdet.control} to match
the value of \code{bb} according to the family of rho functions specified in \code{family}.}

\item{compute.rd}{logical value indicating whether robust leverage distances need to be computed.}

\item{corr.b}{logical value indicating whether a finite-sample correction should be applied
to the M-scale parameter \code{bb}.}

\item{split.type}{determines how categorical and continuous variables are split. See
\code{\link[robustbase]{splitFrame}}.}

\item{initial}{string specifying the initial value for the M-step of the MM-estimator. Valid
options are \code{'S'}, for an S-estimator and \code{'MS'} for an M-S estimator which is
appropriate when there are categorical explanatory variables in the model.}

\item{max.it}{maximum number of IRWLS iterations for the MM-estimator}

\item{refine.tol}{relative convergence tolerance for the S-estimator}

\item{rel.tol}{relative convergence tolerance for the IRWLS iterations for the MM-estimator}

\item{refine.PY}{number of refinement steps for the Pen~a-Yohai candidates}

\item{solve.tol}{relative tolerance for inversion}

\item{trace.lev}{positive values (increasingly) provide details on the progress of the MM-algorithm}

\item{psc_keep}{For pyinit, proportion of observations to remove based on PSCs. The effective proportion of removed
observations is adjusted according to the sample size to be \code{prosac*(1-p/n)}. See \code{\link[pyinit]{pyinit}}.}

\item{resid_keep_method}{For pyinit, how to clean the data based on large residuals. If
\code{"threshold"}, all observations with scaled residuals larger than \code{C.res} will
be removed, if \code{"proportion"}, observations with the largest \code{prop} residuals will
be removed. See \code{\link[pyinit]{pyinit}}.}

\item{resid_keep_thresh}{See parameter \code{resid_keep_method} above. See \code{\link[pyinit]{pyinit}}.}

\item{resid_keep_prop}{See parameter \code{resid_keep_method} above. See \code{\link[pyinit]{pyinit}}.}

\item{py_maxit}{Maximum number of iterations. See \code{\link[pyinit]{pyinit}}.}

\item{py_eps}{Relative tolerance for convergence.  See \code{\link[pyinit]{pyinit}}.}

\item{mscale_maxit}{Maximum number of iterations for the M-scale algorithm. See \code{\link[pyinit]{pyinit}}.}

\item{mscale_tol}{Convergence tolerance for the M-scale algorithm. See \code{\link[pyinit]{pyinit}}.}

\item{mscale_rho_fun}{String indicating the loss function used for the M-scale. See \code{\link[pyinit]{pyinit}}.}

\item{scope}{defines the range of models examined in the \code{"stepwise"} 
search. This should be either a single formula, or a list containing 
components \code{upper} and \code{lower}, both formulae. See 
\code{\link[stats]{step}} for how to specify the formulae and usage.}

\item{scale}{optional parameter for \code{variable.selection="stepwise"}. 
The argument is passed to \code{\link[stats]{step}} or 
\code{\link[RobStatTM]{step.lmrobdetMM}} as appropriate.}

\item{direction}{the mode of \code{"stepwise"} search, can be one of "both", 
"backward", or "forward", with a default of "both". If the \code{scope} 
argument is missing the default for \code{direction} is "backward".}

\item{steps}{the maximum number of steps to be considered for 
\code{"stepwise"}. Default is 1000 (essentially as many as required). It is 
typically used to stop the process early.}

\item{k}{the multiple of the number of degrees of freedom used for the 
penalty in \code{"stepwise"}. Only \code{k = 2} gives the genuine AIC. 
\code{k = log(n)} is sometimes referred to as BIC or SBC. Default is 2.}

\item{nvmin}{minimum size of subsets to examine for \code{"subsets"}. 
Default is 1.}

\item{nvmax}{maximum size of subsets to examine for \code{"subsets"}. 
Default is 8.}

\item{force.in}{index to columns of design matrix that should be in all 
models for \code{"subsets"}. Default is \code{NULL}.}

\item{force.out}{index to columns of design matrix that should be in no 
models for \code{"subsets"}. Default is \code{NULL}.}

\item{method}{one of "exhaustive", "forward", "backward" or "seqrep" 
(sequential replacement) to specify the type of subset search/selection. 
Required if \code{variable selection="subsets"} is chosen. Default is 
"exhaustive".}

\item{really.big}{option for \code{"subsets"}; Must be \code{TRUE} to 
perform exhaustive search on more than 50 variables.}

\item{type}{option for \code{"lars"}. One of "lasso", "lar", 
"forward.stagewise" or "stepwise". The names can be abbreviated to any 
unique substring. Default is "lasso".}

\item{normalize}{option for \code{"lars"}. If \code{TRUE}, each variable is 
standardized to have unit L2 norm, otherwise they are left alone. Default 
is \code{TRUE}.}

\item{eps}{option for \code{"lars"}; An effective zero.}

\item{max.steps}{Limit the number of steps taken for \code{"lars"}; the 
default is \code{8 * min(m, n-intercept)}, with \code{m} the number of 
variables, and \code{n} the number of samples. For \code{type="lar"} or 
\code{type="stepwise"}, the maximum number of steps is 
\code{min(m,n-intercept)}. For \code{type="lasso"} and especially 
\code{type="forward.stagewise"}, there can be many more terms, because 
although no more than \code{min(m,n-intercept)} variables can be active 
during any step, variables are frequently droppped and added as the 
algorithm proceeds. Although the default usually guarantees that the 
algorithm has proceeded to the saturated fit, users should check.}

\item{plot.it}{option to plot the output for \code{\link[lars]{cv.lars}}. 
Default is \code{FALSE}.}

\item{lars.criterion}{an option to assess model selection for the 
\code{"lars"} method; one of "Cp" or "cv". See details. Default is "Cp".}

\item{K}{number of folds for computing the K-fold cross-validated mean 
squared prediction error for \code{"lars"}. Default is 10.}

\item{trace}{If positive (or, not \code{FALSE}), info is printed during the 
running of  \code{\link[stats]{step}}, \code{\link[lars]{lars}} or 
\code{\link[lars]{cv.lars}} as relevant. Larger values may give more 
detailed information. Default is \code{FALSE}.}
}
\value{
A list of the above components. This is only meant to be used by 
\code{fitTsfm}.
}
\description{
Creates a list of control parameters for \code{\link{fitTsfm}}. 
All control parameters that are not passed to this function are set to 
default values. This function is meant for internal use only!!
}
\details{
This control function is used to process optional arguments passed 
via \code{...} to \code{fitTsfm}. These arguments are validated and defaults
are set if necessary before being passed internally to one of the following
functions: \code{\link[stats]{lm}}, \code{\link[RobStatTM]{lmrobdetMM}}, 
\code{\link[stats]{step}}, \code{\link[leaps]{regsubsets}}, 
\code{\link[lars]{lars}} and \code{\link[lars]{cv.lars}}. See their 
respective help files for more details. The arguments to each of these 
functions are listed above in approximately the same order for user 
convenience.

The scalar \code{decay} is used by \code{\link{fitTsfm}} to compute 
exponentially decaying weights for \code{fit.method="DLS"}. Alternately, one 
can directly specify \code{weights}, a weights vector, to be used with 
"LS" or "Robust". Especially when fitting multiple assets, care should be 
taken to ensure that the length of the weights vector matches the number of
observations (excluding cases ignored due to NAs).

\code{lars.criterion} selects the criterion (one of "Cp" or "cv") to 
determine the best fitted model for \code{variable.selection="lars"}. The 
"Cp" statistic (defined in page 17 of Efron et al. (2004)) is calculated 
using \code{\link[lars]{summary.lars}}. While, "cv" computes the K-fold 
cross-validated mean squared prediction error using 
\code{\link[lars]{cv.lars}}.
}
\examples{
\donttest{
# check argument list passed by fitTsfm.control
tsfm.ctrl <- fitTsfm.control(method="exhaustive", nvmin=2)
print(tsfm.ctrl)
}

# used internally by fitTsfm in the example below
 # load data
data(managers, package = 'PerformanceAnalytics')
 # Make syntactically valid column names
colnames(managers)
colnames(managers) <- make.names( colnames(managers))
colnames(managers)

fit <- fitTsfm(asset.names=colnames(managers[,(1:6)]),
               factor.names=colnames(managers[,(7:9)]), 
               data=managers, variable.selection="subsets", 
               method="exhaustive", nvmin=2)

}
\references{
Efron, B., Hastie, T., Johnstone, I., & Tibshirani, R. (2004). Least angle 
regression. The Annals of statistics, 32(2), 407-499.
}
\seealso{
\code{\link{fitTsfm}}, \code{\link[stats]{lm}}, 
\code{\link[RobStatTM]{lmrobdetMM}}, \code{\link[stats]{step}}, 
\code{\link[leaps]{regsubsets}}, \code{\link[lars]{lars}} and 
\code{\link[lars]{cv.lars}}
}
\author{
Sangeetha Srinivasan
}
