% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotUnivariateImportance.R
\name{.plot_univariate_importance}
\alias{.plot_univariate_importance}
\title{Internal plotting function for univariate plots}
\usage{
.plot_univariate_importance(
  x,
  color_by,
  facet_by,
  facet_wrap_cols,
  ggtheme,
  show_cluster,
  discrete_palette,
  gradient_palette,
  x_label,
  y_label,
  legend_label,
  plot_title,
  plot_sub_title,
  caption,
  x_range,
  x_breaks,
  significance_level_shown
)
}
\arguments{
\item{color_by}{(\emph{optional}) Variables used to determine fill colour of plot
objects. The variables cannot overlap with those provided to the \code{split_by}
argument, but may overlap with other arguments. See details for available
variables.}

\item{facet_by}{(\emph{optional}) Variables used to determine how and if facets of
each figure appear. In case the \code{facet_wrap_cols} argument is \code{NULL}, the
first variable is used to define columns, and the remaing variables are
used to define rows of facets. The variables cannot overlap with those
provided to the \code{split_by} argument, but may overlap with other arguments.
See details for available variables.}

\item{facet_wrap_cols}{(\emph{optional}) Number of columns to generate when facet
wrapping. If NULL, a facet grid is produced instead.}

\item{ggtheme}{(\emph{optional}) \code{ggplot} theme to use for plotting.}

\item{show_cluster}{(\emph{optional}) Show which features were clustered together.}

\item{discrete_palette}{(\emph{optional}) Palette used to fill the bars in case a
non-singular variable was provided to the \code{color_by} argument.}

\item{gradient_palette}{(\emph{optional}) Palette to use for filling the bars in
case the \code{color_by} argument is not set. The bars are then coloured
according to their importance. By default, no gradient is used, and the
bars are not filled according to importance. Use \code{NULL} to fill the bars
using the default palette in \code{familiar}.}

\item{x_label}{(\emph{optional}) Label to provide to the x-axis. If NULL, no label
is shown.}

\item{y_label}{(\emph{optional}) Label to provide to the y-axis. If NULL, no label
is shown.}

\item{legend_label}{(\emph{optional}) Label to provide to the legend. If NULL, the
legend will not have a name.}

\item{plot_title}{(\emph{optional}) Label to provide as figure title. If NULL, no
title is shown.}

\item{plot_sub_title}{(\emph{optional}) Label to provide as figure subtitle. If
NULL, no subtitle is shown.}

\item{caption}{(\emph{optional}) Label to provide as figure caption. If NULL, no
caption is shown.}

\item{x_range}{(\emph{optional}) Value range for the x-axis.}

\item{x_breaks}{(\emph{optional}) Break points on the x-axis of the plot.}

\item{significance_level_shown}{Position(s) to draw vertical lines indicating
a significance level, e.g. 0.05. Can be NULL to not draw anything.}
}
\value{
ggplot plot object.
}
\description{
Internal plotting function for univariate plots
}
\seealso{
\itemize{
\item \code{\link{plot_univariate_importance}} for the user interface.
}
}
\keyword{internal}
