% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationCalibrationInfo.R
\name{export_calibration_info}
\alias{export_calibration_info}
\alias{export_calibration_info,familiarCollection-method}
\alias{export_calibration_info,ANY-method}
\title{Extract and export calibration information.}
\usage{
export_calibration_info(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  export_collection = FALSE,
  ...
)

\S4method{export_calibration_info}{familiarCollection}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  export_collection = FALSE,
  ...
)

\S4method{export_calibration_info}{ANY}(
  object,
  dir_path = NULL,
  aggregate_results = TRUE,
  export_collection = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{familiarCollection} object, or other other objects from which
a \code{familiarCollection} can be extracted. See details for more information.}

\item{dir_path}{Path to folder where extracted data should be saved. \code{NULL}
will allow export as a structured list of data.tables.}

\item{aggregate_results}{Flag that signifies whether results should be
aggregated for export.}

\item{export_collection}{(\emph{optional}) Exports the collection if TRUE.}

\item{...}{
  Arguments passed on to \code{\link[=as_familiar_collection]{as_familiar_collection}}
  \describe{
    \item{\code{familiar_data_names}}{Names of the dataset(s). Only used if the \code{object}
parameter is one or more \code{familiarData} objects.}
    \item{\code{collection_name}}{Name of the collection.}
  }}
}
\value{
A data.table (if \code{dir_path} is not provided), or nothing, as all data
is exported to \code{csv} files.
}
\description{
Extract and export calibration information (e.g. baseline
survival) for data in a familiarCollection.
}
\details{
Data is usually collected from a \code{familiarCollection} object.
However, you can also provide one or more \code{familiarData} objects, that will
be internally converted to a \code{familiarCollection} object. It is also
possible to provide a \code{familiarEnsemble} or one or more \code{familiarModel}
objects together with the data from which data is computed prior to export.
Paths to the previous files can also be provided.

All parameters aside from \code{object} and \code{dir_path} are only used if \code{object}
is not a \code{familiarCollection} object, or a path to one.

Currently only baseline survival is exported as supporting calibration
information. See \code{export_calibration_data} for export of direct assessment
of calibration, including calibration and goodness-of-fit tests.
}
