testthat::skip_on_cran()
testthat::skip_on_ci()

# Initiate process clock.
pc <- familiar:::ProcessClock()

initial_time <- pc$time()
Sys.sleep(1)
time_1 <- pc$time()
pc$suspend()
Sys.sleep(1)
time_2 <- pc$time()
time_mark <- microbenchmark::get_nanotime()
Sys.sleep(1)
pc$resume()
time_3 <- pc$time()
pc$suspend()
Sys.sleep(1)
pc$resume()
time_4 <- pc$time()
time_diff <- pc$time(reference_time = time_mark)
pc$close()

testthat::test_that("Assert that process time is correctly recorded.", {
  testthat::expect_equal(initial_time, 0.0, tolerance = 0.1)
  testthat::expect_equal(time_1, 1.0, tolerance = 0.1)
  testthat::expect_equal(time_2, 2.0, tolerance = 0.2)
  testthat::expect_equal(time_3, 3.0, tolerance = 0.2)
  testthat::expect_equal(time_4, 4.0, tolerance = 0.3)
  testthat::expect_equal(time_diff, 2.0, tolerance = 0.2)
})
