% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastOnlineCpt.r
\docType{methods}
\name{addData}
\alias{addData}
\alias{addData,fastOnlineCpt-method}
\title{Add new \eqn{p}-dimensional data point, where \eqn{p} is the number of time series being monitored.}
\usage{
addData(obj, data)

\S4method{addData}{fastOnlineCpt}(obj, data)
}
\arguments{
\item{obj}{An object of the class "fastOnlineCpt".}

\item{data}{The new data of dimension \eqn{n \times p} to be added, where \eqn{n} is the number of new time points being added.}
}
\value{
An object of the class "fastOnlineCpt".
}
\description{
Add new \eqn{p}-dimensional data point, where \eqn{p} is the number of time series being monitored.
}
\examples{
library(fastOnlineCpt)
alpha <- 0.01
halfspent <- 100
spending_sequence <- function(n) { (n/(n+halfspent) - (n-1)/(n-1+halfspent)) * alpha }
obj <- fastOnlineCpt(spending_sequence)
p <- 10
n <- 50
data <- matrix(rnorm(p*n,mean=0),ncol=n)
obj <- addData(obj,data)

}
\references{
Hahn, G. (2021). Online multivariate changepoint detection with type I error control and constant time/memory updates per series. Under review.
}
