% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCats.r
\name{addCats,GRaster-method}
\alias{addCats,GRaster-method}
\alias{addCats}
\alias{addCats<-,GRaster-method}
\alias{addCats<-}
\title{Add rows or columns to the "levels" table of a categorical raster}
\usage{
\S4method{addCats}{GRaster}(x, value, merge = FALSE, layer = 1)

\S4method{addCats}{GRaster}(x, layer = 1) <- value
}
\arguments{
\item{x}{A \code{GRaster}.}

\item{value}{A \code{data.frame}, \code{data.table}, a list of \code{data.frames} or \code{data.tables} with one per raster layer, or a categorical \code{SpatRaster}. The table's first column is the "value" column and must contain numeric values (of class \code{numeric} or \code{character}). If a \code{SpatRaster} is supplied, then its categories will be transferred to the \code{GRaster}.}

\item{merge}{Logical (function \code{addCats()}): If \code{FALSE} (default), columns will be combined with the existing "levels" table using \code{\link[=cbind]{cbind()}}. If \code{TRUE}, they will be combined using \code{\link[data.table:merge]{data.table::merge()}}.}

\item{layer}{Numeric integers, logical vector, or character: Layer(s) to which to add or from which to drop levels.}
}
\value{
A \code{GRaster}. The "levels" table of the raster is modified.
}
\description{
\code{addCats()} and \verb{addCats()<-} add information to a categorical`GRaster's "levels" table.
\itemize{
\item addCats()` uses \code{\link[data.table:merge]{data.table::merge()}} or \code{\link[=cbind]{cbind()}} to do this--it does not add new rows, but rather new columns.
\item \verb{addCats()<-} uses \code{\link[=rbind]{rbind()}} to add new categories (rows) to the "levels" table.
}

GRaster\verb{s can represent categorical data (see }vignette("GRasters", package = "fasterRaster")\verb{). Cell values are actually integers, each corresponding to a category, such as "desert" or "wetland." A categorical raster is associated with a "levels" table that matches each value to a category name. The table must be }NULL` (i.e., no categories--so not a categorical raster), or have at least two columns. The first column must have integers and represent raster values. One or more subsequent columns must have category labels. The column with these labels is the "active category".
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data: Land cover raster
madCover <- fastData("madCover")

# Convert categorical SpatRaster to categorical GRaster:
cover <- fast(madCover)

### Properties of categorical rasters

cover # note categories
is.factor(cover) # Is the raster categorical?
nlevels(cover) # number of levels
levels(cover) # just the value and active column
cats(cover) # all columns
minmax(cover) # min/max values
minmax(cover, levels = TRUE) # min/max categories
catNames(cover) # column names of the levels table
missingCats(cover) # categories in table with no values in raster
freq(cover) # frequency of each category (number of cells)
zonalGeog(cover) # geometric statistics

### Active column

# Which column sets the category labels?
activeCat(cover)
activeCat(cover, names = TRUE)

activeCats(c(cover, cover))

# Choose a different column for category labels:
levels(cover)
activeCat(cover) <- 2
levels(cover)

### Managing levels tables

# Remove unused levels:
nlevels(cover)
cover <- droplevels(cover)
nlevels(cover)

# Re-assign levels:
value <- c(20, 30, 40, 50, 120, 130, 140, 170)
label <- c("Cropland", "Cropland", "Forest", "Forest",
 "Grassland", "Shrubland", "Herbaceous", "Flooded")

newCats <- data.frame(value = value, label = label)

cover <- categories(cover, layer = 1, value = newCats)
cats(cover)

# This is the same as:
levels(cover) <- newCats
cats(cover)

# Are there any values not assigned a category?
missingCats(cover)

# Let's assign a category for value 210 (water):
water <- data.frame(value = 210, label = "Water")
addCats(cover) <- water
levels(cover)

# Add more information to the levels table using merge():
landType <- data.frame(
     Value = c(20, 30, 40, 50, 120),
     Type = c("Irrigated", "Rainfed", "Broadleaf evergreen",
     "Broadleaf deciduous", "Mosaic with forest")
)
cats(cover)
cover <- addCats(cover, landType, merge = TRUE)
cats(cover)

### Logical operations on categorical rasters

cover < "Forest" # 1 for cells with a value < 40, 0 otherwise
cover <= "Forest" # 1 for cells with a value < 120, 0 otherwise
cover == "Forest" # 1 for cells with value of 40-120, 0 otherwise
cover != "Forest" # 1 for cells with value that is not 40-120, 0 otherwise
cover > "Forest" # 1 for cells with a value > 120, 0 otherwise
cover >= "Forest" # 1 for cells with a value >= 120, 0 otherwise

cover \%in\% c("Cropland", "Forest") # 1 for cropland/forest cells, 0 otherwise

### Combine categories from different rasters

# For the example, will create a second categorical raster fromm elevation.

# Divide elevation raster into "low/medium/high" levels:
madElev <- fastData("madElev")
elev <- fast(madElev)
elev <- project(elev, cover, method = "near") # convert to same CRS
fun <- "= if(madElev < 100, 0, if(madElev < 400, 1, 2))"
elevCat <- app(elev, fun)

levs <- data.frame(
     value = c(0, 1, 2),
     elevation = c("low", "medium", "high")
)
levels(elevCat) <- list(levs)

# Combine levels:
combined <- concats(cover, elevCat)
combined
levels(combined)

# Combine levels, treating value/NA combinations as new categories:
combinedNA <- concats(cover, elevCat, na.rm = FALSE)
combinedNA
levels(combinedNA)

}
}
\seealso{
\code{\link[terra:factors]{terra::addCats()}}, \code{\link[=concats]{concats()}}, \code{\link[=combineLevels]{combineLevels()}}, \code{\link[=droplevels]{droplevels()}}, \verb{vignette("GRasters", package = "fasterRaster"}
}
