% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.r
\name{kernel,GVector-method}
\alias{kernel,GVector-method}
\alias{kernel}
\title{Kernel density estimator of points}
\usage{
\S4method{kernel}{GVector}(x, y, kernel = "Epanechnikov", optimize = TRUE, h = NULL)
}
\arguments{
\item{x}{A "points" \code{GVector}.}

\item{y}{A \code{GRaster}: The extent and resolution of this raster will be used to create the density raster. Otherwise, values in this raster are ignored.}

\item{kernel}{Character: Name of the kernel function to use. Possible values include:
\itemize{
\item \code{"Epanechnikov"} (default)
\item \code{"Gaussian"}
\item \code{"uniform"}
\item \code{"triangular"}
\item \code{"quartic"}
\item \code{"triweight"}
\item \code{"cosine"}
}

Partial matching is used, and case is ignored.}

\item{optimize}{Logical: If \code{TRUE} (default), then attempt to find the optimal radius less than or equal to the \code{radius} value using the "Gaussian" kernel. If \code{FALSE}, use the \code{radius} value as-is.}

\item{h}{Numeric or \code{NULL} (default): Smoothing bandwidth of kernel estimator.

If this is \code{NULL}, the Epanechnikov kernel is used, and \code{optimize} is \code{TRUE}, then Silverman's rule-of-thumb is used to estimate the optimal value of \code{h}:
\deqn{h = 0.9 * min(\sigma_x / n^1/6, \sigma_y / n^1/6)}

If the Gaussian kernel is used, and \code{optimize} is \code{TRUE}, then the \strong{GRASS} \code{v.kernel} function will attempt to identify the optimal bandwidth, up to the value of \code{h}, if \code{h} is defined.

Otherwise, if \code{h} is \code{NULL}, then the value will be arbitrarily set at 1/5th of the shorter of the distance of the x- and y-extent of the points.}
}
\value{
A \code{GRaster}.
}
\description{
\code{kernel()} creates a raster using a kernel density estimator of the density of points in a "points" \code{GVector}.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)
library(terra)

# Elevation raster, plant specimen collections, rivers vector,
# outline of area vector
madElev <- fastData("madElev")
madDypsis <- fastData("madDypsis")

# Convert to fasterRaster format:
elev <- fast(madElev)
dypsis <- fast(madDypsis)

# Kernel density estimation:
kde <- kernel(dypsis, elev)
plot(kde)
plot(dypsis, add = TRUE, pch = 1)

}
}
\seealso{
\strong{GRASS} manual page for tool \code{v.kernel} (see \code{grassHelp("v.kernel")})
}
