% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{ft_replace_na}
\alias{ft_replace_na}
\title{Replace NA Values in Factor Vector}
\usage{
ft_replace_na(factor_vec, replacement_level)
}
\arguments{
\item{factor_vec}{A factor vector.}

\item{replacement_level}{A string specifying the level to replace \code{NA} values with.}
}
\value{
A factor vector with \code{NA} values replaced.
}
\description{
Replaces \code{NA} values in a factor vector with a specified level.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', NA, 'banana', 'cherry', NA))

# Replace NAs with 'Unknown'
ft_replace_na(factor_vec, replacement_level = 'Unknown')
}
\author{
Kai Guo
}
