% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg_wfs.R
\name{bkg_wfs}
\alias{bkg_wfs}
\alias{bkg_feature_types}
\title{BKG WFS}
\usage{
bkg_wfs(
  type_name,
  endpoint = type_name,
  version = "2.0.0",
  method = NULL,
  format = "application/json",
  layer = NULL,
  epsg = 3035,
  properties = NULL,
  filter = NULL,
  server = sgx_base(),
  ...
)

bkg_feature_types(endpoint, server = sgx_base())
}
\arguments{
\item{type_name}{Feature type of the WFS to retrieve. You can use
\code{bkg_feature_types} to retrieve a list of feature type names for a
given endpoint.}

\item{endpoint}{Endpoint to interface. Note that \code{wfs_} is appended
and only the rest of the product name must be provided. For example,
\code{wfs_vg250} becomes \code{vg250}. Defaults to the value of
\code{type_name}.}

\item{version}{Service version of the WFS. Usually 2.0.0, but some services
still use 1.0.0 or 1.1.0.}

\item{method}{HTTP method to use for the request. \code{GET} requests
provide parameters using URL queries. Filters must be provided as CQL
queries. While this is less error-prone, it allows a maximum number of
only 2048 characters. Especially when providing more sophisticated spatial
queries, \code{GET} queries are simply not accepted by the services. In
these cases it makes sense to use \code{POST} requests instead.

If \code{NULL}, the method is inferred from the type of filter query
provided to \code{filter} (either XML or CQL). If no filter is provided,
the method is inferred from \code{getOption("ffm_query_language")}.}

\item{format}{Content type of the output. This value heavily depends
the endpoint queried. Most services allow \code{application/json} but some
only support GML outputs. When in doubt, inspect the \code{GetCapabilities}
of the target service. Defaults to \code{"application/json"}.}

\item{layer}{If \code{format} specifies a GML output, \code{layer}
specifies which layer from the downloaded GML file to read. Only necessary
if the GML file actually contains multiple layers. Defaults to \code{NULL}.}

\item{epsg}{Numeric value giving the EPSG identifier of the coordinate
reference system (CRS). The EPSG code is automatically formatted in a
OGC-compliant manner. Note that not all EPSG codes are supported. Inspect
the \code{GetCapabilities} of the target service to find out which
EPSG codes are available. Defaults to EPSG:3035.}

\item{properties}{Names of columns to include in the output. Defaults to
\code{NULL} (all columns).}

\item{filter}{A WFS filter query (CQL or XML) created by
\code{\link{wfs_filter}}.}

\item{server}{WFS server domain to use. Defaults to the SGX spatial data
center of the BKG.}

\item{...}{Further parameters passed to the WFS query. In case of
\code{POST} requests, additional namespaces that may be necessary to query
the WFS. Argument names are interpreted as the prefix (e.g.
\code{xmlns:wfs}) and argument values as namespace links.}
}
\value{
An sf tibble
}
\description{
Low-level interface to BKG-style web feature services (WFS). This function
is used in all high-level functions of \code{ffm} that depend on a WFS,
e.g., \code{\link{bkg_admin}}.

\code{bkg_feature_types} lists all available feature types for a given
endpoint.
}
\examples{
\dontshow{if (getFromNamespace("ffm_run_examples", ns = "ffm")()) withAutoprint(\{ # examplesIf}
bkg_feature_types("vg5000_0101")

bkg_wfs(
  "vg5000_lan",
  endpoint = "vg5000_0101",
  count = 5,
  properties = "gen",
  epsg = 4326
)[-1]

# Filters are created using `wfs_filter()`
bkg_wfs(
  "vg5000_krs",
  endpoint = "vg5000_0101",
  properties = "gen",
  filter = wfs_filter(sn_l == 10)
)[-1]
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{bkg_wcs}} for a low-level WCS interface

\code{\link{wfs_filter}} for filter constructors
}
