% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross.R
\name{cross_spec}
\alias{cross_spec}
\alias{cross_spec.default}
\alias{cross_spec.ts}
\alias{cross_spec.array}
\alias{cross_spec.fftab}
\title{Compute the Cross-Spectrum (Cross FFT)}
\usage{
cross_spec(a, b, norm = FALSE, conj = TRUE)

\method{cross_spec}{default}(a, b, norm = FALSE, conj = TRUE)

\method{cross_spec}{ts}(a, b, norm = FALSE, conj = TRUE)

\method{cross_spec}{array}(a, b, norm = FALSE, conj = TRUE)

\method{cross_spec}{fftab}(a, b, norm = FALSE, conj = TRUE)
}
\arguments{
\item{a}{The first input for the cross FFT. Supported types include numeric
vectors, \code{ts} objects, arrays, and \code{fftab} objects.}

\item{b}{The second input for the cross FFT. Must match the dimensions or
structure of \code{a}.}

\item{norm}{Logical; if \code{TRUE}, normalizes the Fourier transforms before
computation. Default is \code{FALSE}.}

\item{conj}{Logical; if \code{TRUE}, uses the complex conjugate of the Fourier
transform of \code{b}. Default is \code{TRUE}.}
}
\value{
An object representing the cross-spectrum:
\itemize{
\item For \code{default} and \code{fftab} methods: A \code{fftab} object.
\item For \code{ts} objects: A \code{fftab} object with \code{.tsp} attributes inherited
from \code{a}.
\item For arrays: A \code{fftab} object with \code{.dim} attributes inherited
from \code{a}.
}
}
\description{
The \code{cross_spec} function computes the cross-spectrum between two inputs
using the Fourier transform. It supports multiple input types including
numeric vectors, time series (\code{ts}), arrays, and \code{fftab} objects.
The function provides options for normalization and controlling whether the
conjugate of the second input is used.
}
\section{Methods (by class)}{
\itemize{
\item \code{cross_spec(default)}: Default method for computing cross FFT.
Converts inputs to \code{fftab} objects before computation.

\item \code{cross_spec(ts)}: Method for time series (\code{ts}) objects.
Ensures the time series frequencies are consistent and preserves the \code{tsp} attribute.

\item \code{cross_spec(array)}: Method for array inputs.
Ensures dimensions are consistent and preserves the \code{dim} attribute.

\item \code{cross_spec(fftab)}: Method for \code{fftab} objects.
Performs the cross-frequency transform directly using the Fourier transforms of \code{a} and \code{b}.

}}
\examples{
cross_spec(rnorm(8), rnorm(8), norm = TRUE)

cross_spec(
  ts(rnorm(8), frequency = 4),
  ts(rnorm(8), frequency = 4)
)

}
\seealso{
\code{\link[=fftab]{fftab()}}
}
