% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repr.R
\name{has_cplx}
\alias{has_cplx}
\alias{has_rect}
\alias{has_polr}
\title{Check Representations of a \code{fftab} Object}
\usage{
has_cplx(x)

has_rect(x)

has_polr(x)
}
\arguments{
\item{x}{A \code{fftab} object.}
}
\value{
Logical value (\code{TRUE} or \code{FALSE}) indicating whether the specified representation exists.
}
\description{
These functions check if specific representations are present in a \code{fftab} object:
}
\details{
\itemize{
\item \strong{\code{has_cplx()}}: Checks if the object has complex representation (\code{fx} column).
\item \strong{\code{has_rect()}}: Checks if the object has rectangular representation (\code{re}, \code{im} columns).
\item \strong{\code{has_polr()}}: Checks if the object has polar representation (\code{mod}, \code{arg} columns).
}
}
\examples{
fftab(c(1, 0, -1, 0)) |> has_cplx()

fftab(c(1, 0, -1, 0)) |> has_rect()

fftab(c(1, 0, -1, 0)) |> has_polr()

}
\seealso{
\code{\link[=to_cplx]{to_cplx()}}, \code{\link[=get_repr]{get_repr()}}
}
