% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross.R
\name{phase_diff}
\alias{phase_diff}
\title{Compute Phase Difference and Maximum Correlation Between Two Signals}
\usage{
phase_diff(a, b)
}
\arguments{
\item{a}{A numeric vector or time series representing the first signal.}

\item{b}{A numeric vector or time series representing the second signal.}
}
\value{
A numeric vector of length two:
\itemize{
\item The first element represents the \strong{phase difference} (in radians) required to maximize alignment between the two signals.
\item The second element represents the \strong{maximum normalized correlation} achieved after phase alignment.
}
}
\description{
Computes the phase difference and maximum normalized correlation between two input signals
after phase-aligning the second signal (\code{b}) to the first signal (\code{a}).
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function performs the following steps:
\enumerate{
\item Computes the Fourier Transform of both input signals using \code{fftab}.
\item Calculates the \strong{cross-spectrum} of the signals.
\item Converts the cross-spectrum to polar form and computes the weighted average phase difference.
\item Adjusts the phase of the second signal (\code{b}) using \code{.shift_phase} to maximize alignment with the first signal (\code{a}).
\item Computes the \strong{normalized correlation} between the phase-aligned signals.
}

The correlation is normalized using the variances of both signals and will generally be \strong{higher} than the correlation
between the original signals due to the optimal phase alignment.
}
\examples{
phase_diff(
  sin(seq(0, 2 * pi, length.out = 128)),
  cos(seq(0, 2 * pi, length.out = 128))
)

}
\seealso{
\itemize{
\item \code{\link[=fftab]{fftab()}}
\item \code{\link[=cross_spec]{cross_spec()}}
}
}
