% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhir_design.R, R/fhir_table_list.R
\docType{methods}
\name{fhir_design}
\alias{fhir_design}
\alias{fhir_design,fhir_table_description-method}
\alias{fhir_design,list-method}
\alias{fhir_design,fhir_table_list-method}
\title{Create a \linkS4class{fhir_design} object}
\usage{
fhir_design(...)

\S4method{fhir_design}{fhir_table_description}(...)

\S4method{fhir_design}{list}(...)

\S4method{fhir_design}{fhir_table_list}(...)
}
\arguments{
\item{...}{One or more \code{fhir_table_description} objects or a named list containing
\code{fhir_table_description} objects, or an object of class \linkS4class{fhir_df_list}/\linkS4class{fhir_dt_list}.
See \code{\link[=fhir_table_description]{fhir_table_description()}}.}
}
\description{
A \code{fhir_design} is a named list of \code{fhir_table_description} objects (See \code{\link[=fhir_table_description]{fhir_table_description()}})
and should be created using the function described here. The design is used in \code{\link[=fhir_crack]{fhir_crack()}} to tell
the function how to flatten each resource type.
}
\details{
A \code{fhir_design} looks for example like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{A fhir_design with 2 table_descriptions:
A fhir_table_description with the following elements:

	fhir_resource_type: Patient

fhir_columns:
	------------ -----------------
	column name | xpath expression
------------ -----------------
	id          | id
name        | name/family
gender      | gender
------------ -----------------

	sep:           '||'
brackets:      '[', ']'
rm_empty_cols: FALSE
format:        'compact'
keep_attr:     TRUE

A fhir_table_description with the following elements:

	fhir_resource_type: MedicationAdministration

fhir_columns:
	An empty fhir_columns object

sep:           ':::'
brackets:      no brackets
rm_empty_cols: FALSE
format:        'wide'
keep_attr:     TRUE
}\if{html}{\out{</div>}}

The names of the table_descriptions are taken from the names of the arguments. If the table_descriptions are
created within the call to \code{fhir_design} and therefore have no names, the names will be created from the respective
resource type. See examples.

For backwards compatibility it is for the moment also possible to build it from an
old-style design as used in \verb{fhircrackr (< 1.0.0)}. See examples.

If this function is given an object of class \linkS4class{fhir_df_list} or \linkS4class{fhir_dt_list}, it will
extract the design that was used to create the respective list.
}
\examples{

####Example 1####

###create fhir_table_descriptions first
#see ?fhir_table_description for explanation

pat <- fhir_table_description(
    resource      = "Patient",
    cols          = c(
        id            = "id",
        name          = "name/family",
        gender        = "gender"
    ),
    sep           = "||",
    brackets      = c("[", "]"),
    rm_empty_cols = FALSE

)

meds <- fhir_table_description(resource = "MedicationAdministration")

###create design
#First option: Explicitly define names

design1 <- fhir_design(Pats = pat, Medics = meds)
print(design1)


#Second option: Names are taken from the object names

design2 <- fhir_design(pat, meds)
print(design2)


#Third option: Create table_description within fhir_design

design3 <- fhir_design(fhir_table_description(resource = "MedicationAdministration"))
print(design3)


#Fourth option: Names are taken from named list

design3 <- fhir_design(list(Patients = pat, Medications = meds))
print(design3)


###Example 2###
###Extract design from fhir_df_list/fhir_dt_list

#unserialize and crack example bundles
med_bundles <- fhir_unserialize(bundles = medication_bundles)
dfs <- fhir_crack(bundles = med_bundles, design = design1)

#extract design

fhir_design(dfs)

}
\seealso{
\code{\link[=fhir_table_description]{fhir_table_description()}}, \code{\link[=fhir_crack]{fhir_crack()}}
}
