% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{as_figma_document}
\alias{as_figma_document}
\title{Convert a \code{httr} response object to a Figma Document object}
\usage{
as_figma_document(response, ...)
}
\arguments{
\item{response}{a \code{response} object produced by a \code{httr} HTTP method
(e.g. \code{httr::GET()}, \code{httr::POST()}, etc.);}

\item{...}{Further arguments passed by the caller. Currently ignored by the
function;}
}
\value{
Returns an object of class \code{figma_document}, which is a R list with these elements:

\itemize{
\item \strong{document}: a R list with all of the document metadata of your Figma file;
\item \strong{canvas}: a R list with all of the canvas and objects data of your Figma file;
\item \strong{n_canvas}: a integer with the number of canvas/pages in your Figma file;
\item \strong{n_objects}: a vector of integers with the number of objects in each canvas/page of your Figma file;
}
}
\description{
This function receives a \code{httr::response()} object, and outputs a
\code{figma_document} object.
}
\details{
A Figma Document is a just a R list with a more organized structure than the
raw content of the HTTP request in \code{httr::response()}. You can access
each part of this list with \code{`$`} and \code{`[[`} operators. See Value section to
understand what is in each element of this list.

\code{as_figma_document()} will call different parsers depending on what kind
of elements are present in the content of the \code{response} object it receives
as input. These elements define what kind of data is present in the \code{response}
object, and how it is structured.

If this input object have a \code{document} element in the top-level of
the content, is likely that this input object was produced by \code{figma::get_figma_file()}.
In this case, \code{as_figma_document()} will call \code{figma:::parse_figma_file()} to parse
the contents of the HTTP request.

In the other hand, if this input object have a \code{nodes} element in the top-level of
the content, is likely that this input object was produced by \code{figma::get_figma_page()}.
In this case, \code{as_figma_document()} will call \code{figma:::parse_figma_page()} to parse
the contents of the HTTP request.

If none of these key elements ("document" or "nodes") are found in the top-level of the
content of the \code{response} object, \code{as_figma_document()} will issue an error
to the user, telling it could not recognize the source of the \code{response} object.
}
\examples{
\dontrun{
file_key <- "hch8YlkgaUIZ9raDzjPvCz"
token <- "my figma token secret ... "
# Returns a `response` object:
r <- figma::get_figma_file(file_key, token)
result <- figma::as_figma_document(r)
}
}
