% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{powersys_electricity_shortage_status_RTD}
\alias{powersys_electricity_shortage_status_RTD}
\title{Electricity shortage status}
\usage{
powersys_electricity_shortage_status_RTD(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 3 min and unit type 0-3.
}
\description{
Electricity shortage status. An electricity shortage occurs when electricity production and imports are not enough to cover electricity consumption. In such cases, it is necessary to restrict consumption to stop the power system from crashing altogether. Fingrid informs citizens on its (website)(https://www.fingrid.fi/en/grid/information-regarding-electricity-shortages/) and with a press release in accordance with the three-step procedure when the situation possibly escalates.* 0 = Normal* 1 = Electricity shortage possible* 2 = High risk of electricity shortage* 3 = Electricity shortage The data is updated every 3 minutes.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- powersys_electricity_shortage_status_RTD(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/336
}
